% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/eratosthenes.R
\name{gibbs_ad}
\alias{gibbs_ad}
\alias{gibbs_ad.list}
\title{Gibbs Sampler for Archaeological Dating}
\usage{
gibbs_ad(
  sequences,
  finds = NULL,
  samples = 10^5,
  tpq = NULL,
  taq = NULL,
  alpha = -5000,
  omega = 1950,
  trim = TRUE,
  rule = "naive"
)

\method{gibbs_ad}{list}(
  sequences,
  finds = NULL,
  samples = 10^5,
  tpq = NULL,
  taq = NULL,
  alpha = -5000,
  omega = 1950,
  trim = TRUE,
  rule = "naive"
)
}
\arguments{
\item{sequences}{A \code{list} of relative sequences of elements (e.g., contexts).}

\item{finds}{Optional. A \code{list} of finds related to (contained in) the elements of \code{sequences}. If one includes this ob}

\item{samples}{Number of samples. Default is \code{10^5}.}

\item{tpq}{A \code{list} containing \emph{termini post quem}. Each object in the list consists of:
\itemize{
\item \code{id} A \code{character} ID of the  \emph{t.p.q.}, such as a reference or number.
\item \code{assoc} The element in \code{code} to which the \emph{t.p.q.} is associated.
\item \code{samples} A vector of samples drawn from the appertaining probability density function of that \emph{t.p.q.}
}}

\item{taq}{A \code{list} containing \emph{termini ante quem}. Each object in the list consists of:
\itemize{
\item \code{id} A \code{character} ID of the  \emph{t.a.q.}, such as a reference or number.
\item \code{assoc} The element in \code{code} to which the \emph{t.p.q.} is associated.
\item \code{samples} A vector of samples drawn from the appertaining probability density function of that \emph{t.p.q.}
}}

\item{alpha}{An initial \emph{t.p.q.} to limit any elements which may occur before the first provided \emph{t.p.q.} Default is \code{-5000}.}

\item{omega}{A final \emph{t.a.q.} to limit any elements which may occur after the after the last provided \emph{t.a.q.} Default is \code{1950}.}

\item{trim}{A logical value to determine whether elements that occur before the first \emph{t.p.q.} and after the last \emph{t.a.q.} should be ommitted from the results (i.e., to "trim" elements at the ends of the sequence, whose marginal densities depend on the selection of \code{alpha} and \code{omega}). Default is \code{TRUE}.}

\item{rule}{The rule for computing an estimated date of production of a find-type, either \code{"earliest"}, selecting a production date between the earliest deposition of that type and the next most earliest context,  or \code{"naive"} (the default), which will select a production date any time between the distribution of that "earliest" date and the depositional date of that artifact.}
}
\value{
A \code{list} object of class \code{marginals} which contains the following:
\itemize{
\item \code{deposition} A \code{list} of samples from the marginal density of each context's depositional date.
\item \code{externals} A \code{list} of samples of the marginal density of each constrant (\emph{t.p.q.} and \emph{t.a.q.]}), as conditioned upon the occurrence of other depositional
\item \code{production} If a \code{finds} object has been input, samples of the marginal density of the production date of finds types will be included in the output.
}
}
\description{
A Gibbs sampler for archaeological dating, to fit relative sequences to absolute, calendrical dates. Elements can be associated with \emph{termini post quem} (\emph{t.p.q.}) and \emph{termini ante quem} (\emph{t.a.q.}), which are treated as a given probability density function \eqn{f(t)}. This function may take any form, a single date (i.e., with a probability of 1), a continuous uniform distribution (any time between two dates), or a bespoke density (as with calibrated radicarbon dates). Inputs of this function take samples drawn from their respective density functions.
}
\examples{
x <- c("A", "B", "C", "D", "E", "F", "G", "H", "I", "J")
y <- c("B", "D", "G", "H", "K")
z <- c("F", "K", "L", "M")
contexts <- list(x, y, z)

f1 <- list(id = "find01", assoc = "D", type = c("type1", "form1"))
f2 <- list(id = "find02", assoc = "E", type = c("type1", "form2"))
f3 <- list(id = "find03", assoc = "G", type = c("type1", "form1"))
f4 <- list(id = "find04", assoc = "H", type = c("type2", "form1"))
f5 <- list(id = "find05", assoc = "I", type = "type2")
f6 <- list(id = "find06", assoc = "H", type = NULL)

artifacts <- list(f1, f2, f3, f4, f5, f6)
 
# external constraints
coin1 <- list(id = "coin1", assoc = "B", type = NULL, samples = runif(100,-320,-300))
coin2 <- list(id = "coin2", assoc = "G", type = NULL, samples = runif(100,37,41))
destr <- list(id = "destr", assoc = "J", type = NULL, samples = 79)

tpq_info <- list(coin1, coin2)
taq_info <- list(destr)

result <- gibbs_ad(contexts, finds = artifacts, samples = 10^4, tpq = tpq_info, taq = taq_info)
}
