% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/same_dist.R
\name{same_dist}
\alias{same_dist}
\alias{same_dist.matrix}
\alias{same_dist.network}
\title{Compare pairs of networks to see if those came from the same distribution}
\usage{
same_dist(net0, net1, ...)

\method{same_dist}{matrix}(net0, net1, attrnames = NULL, ...)

\method{same_dist}{network}(net0, net1, attrnames = NULL, ...)
}
\arguments{
\item{net0, net1}{Networks to be compared.}

\item{...}{Ignored.}

\item{attrnames}{Character vector. (optional) Names of the vertex attributes
to be be compared on. This is ignored in the matrix case.}
}
\value{
A logical with an attribute \code{what}. \code{TRUE} meaning that the two
networks come from the same distribution, and \code{FALSE} meaning that they do
not. If \code{FALSE} the \code{what} attribute will be equal to either \code{"size"} or
the name of the attribute that failed the comparison.
}
\description{
If two networks are of the same size, and their vertex attributes are
equal in terms of set comparison, then we say those came from the same
distribution
}
\details{
This function is used during the call of \link{ergmito_formulae} to
check whether the function can recycle previously computed statistics for
the likelihood function. In the case of models that only contain structural
terms, i.e. attribute less, this can save significant amount of computing
time and memory.
}
\examples{
data(fivenets)
same_dist(fivenets[[1]], fivenets[[2]]) # Yes, same size
same_dist(fivenets[[1]], fivenets[[2]], "female") # No, different attr dist
}
