% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/co.R
\name{co}
\alias{co}
\alias{co.default}
\alias{co.character}
\alias{co.factor}
\alias{co.data.frame}
\title{Customizable Object Aware String}
\usage{
\method{co}{default}(object, one = "\%o has \%n value\%s: \%c",
  some = one, none = gsub(": ", "", some), lots = some, nlots = 10,
  conjunction = NULL, bracket = "", ellipsis = nlots,
  oxford = FALSE, object_name = substitute(object), ...)

\method{co}{character}(object, one = "\%o has \%n value\%s: \%c",
  some = one, none = gsub(": ", "", some), lots = some, nlots = 10,
  conjunction = NULL, bracket = "'", ellipsis = nlots,
  oxford = FALSE, object_name = substitute(object), ...)

\method{co}{factor}(object, one = "\%o has \%n value\%s: \%c",
  some = one, none = gsub(": ", "", some), lots = some, nlots = 10,
  conjunction = NULL, bracket = "'", ellipsis = nlots,
  oxford = FALSE, object_name = substitute(object), ...)

\method{co}{data.frame}(object, one = "\%o has \%n column\%s\\n\%c",
  some = one, none = none, lots = some, nlots = 10,
  conjunction = NULL, ellipsis = nlots, oxford = FALSE,
  object_name = substitute(object), ...)
}
\arguments{
\item{object}{The object of length \code{n}}

\item{one}{The string to return if \code{n = 1}}

\item{some}{The string to return if n is in \code{2, 3, ..., nlots - 1}}

\item{none}{The string to return if \code{n = 0}}

\item{lots}{The string to return if \code{n >= nlots}}

\item{nlots}{A count of the number of values to consider to be lots}

\item{conjunction}{A string of the conjunction to separate the last value by or NULL.}

\item{bracket}{A string to bracket the values by.}

\item{ellipsis}{A count of the total number of values required to use an ellipsis.}

\item{oxford}{A flag indicating whether to use the Oxford comma (if conjunction).}

\item{object_name}{A string of the object name.}

\item{...}{Unused.}
}
\description{
Produces a fully customizable object aware string with consecutive values
separated by columns.
}
\section{\code{sprintf}-like types}{

The following \code{sprintf}-like types can be used in the custom messages:

\describe{
  \item{\code{c}}{the object as a comma separated list (produced by a \code{\link{cc}} function)}
  \item{\code{n}}{the length of the object}
  \item{\code{o}}{the name of the object}
  \item{\code{s}}{'s' if n != 1 otherwise ''}
  \item{\code{r}}{'are' if n != 1 otherwise 'is'}
}
}

\examples{
co(character())
x <- "fox"
co(x)
co(c(1,2,5))
co(1:10)
co(datasets::mtcars)
}
\seealso{
\code{\link{cc}}
}
