% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/module-filterData.R
\name{filterData-module}
\alias{filterData-module}
\alias{filterDataUI}
\alias{filterDataServer}
\title{Modules for creating filters from a data.frame}
\usage{
filterDataUI(id)

filterDataServer(input, output, session, data, vars = NULL,
  width = "100\%")
}
\arguments{
\item{id}{Module's id}

\item{input}{standard \code{shiny} input.}

\item{output}{standard \code{shiny} output.}

\item{session}{standard \code{shiny} session.}

\item{data}{a \code{data.frame} or a \code{\link[shiny]{reactive}} function returning a \code{data.frame}.}

\item{vars}{variables for which to create filters, by default all variables in \code{data}.}

\item{width}{the width of the input, e.g. \code{400px}, or \code{100\%}.}
}
\value{
a \code{\link[shiny]{reactiveValues}} containing the data filtered under 
slot \code{data}, the R code to reproduce the filtering under slot \code{code} and a logical
vector for indexing data under slot \code{index}.
}
\description{
Modules for creating filters from a data.frame
}
\note{
Column's names can be modified to be valid R names.
 discrete columns with more than 50 unique values will be discarded.
}
\examples{

if (interactive()) {
library(shiny)
library(shinyWidgets)
library(esquisse)

ui <- fluidPage(
  
  tags$h1("Module Filter Data"),
  
  fluidRow(
    column(
      width = 4,
      radioButtons(
        inputId = "dataset", label = "Data:",
        choices = c("iris", "mtcars", "Titanic")
      ),
      filterDataUI("ex")
    ),
    column(
      width = 8,
      progressBar(
        id = "pbar", value = 100, 
        total = 100, display_pct = TRUE
      ),
      DT::dataTableOutput(outputId = "tab"),
      verbatimTextOutput(outputId = "code")
    )
  )
  
)

server <- function(input, output, session) {
  
  data <- reactive({
    if (input$dataset == "iris") {
      return(iris)
    } else if (input$dataset == "mtcars") {
      return(mtcars)
    } else {
      return(as.data.frame(Titanic))
    }
  })
  
  res <- callModule(module = filterDataServer, 
                    id = "ex", data = data)
  
  observeEvent(res$data, {
    updateProgressBar(
      session = session, id = "pbar", 
      value = nrow(res$data), total = nrow(data())
    )
  })
  
  output$tab <- DT::renderDataTable(res$data)
  
  output$code <- renderPrint(res$code)
  
}

shinyApp(ui, server)
}

}
