% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_inventory_cmip5.R
\name{get_inventory_cmip5}
\alias{get_inventory_cmip5}
\title{Get inventory from path containing CMIP5 GCMs .nc files}
\usage{
get_inventory_cmip5(path, add_files = TRUE)
}
\arguments{
\item{path}{Path that will be searched recursively for .nc files.}

\item{add_files}{Boolean (default \code{TRUE}), if \code{TRUE}, will add a
column containing lists of associated files with their full paths (useful
e.g. for further processing).}
}
\value{
A data.table with the inventory information.
}
\description{
Returns a data.table with information by splitting the netcdf files into
their components (GCM, variable, experiment, ...) and aggregates over
years.
}
\examples{
# some empty example files
fn_zip <- system.file("extdata", "inv-test-files-cmip5.zip", package = "eurocordexr")
tmpdir <- tempdir()
unzip(fn_zip, exdir = tmpdir)

dat_inv <- get_inventory_cmip5(fs::path(tmpdir, "testdata-cmip5", "basic"))
print(dat_inv)

}
\seealso{
\code{\link{check_inventory_cmip5}} for performing some checks.
}
