% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/epmc_tm_count.r
\name{epmc_tm_count}
\alias{epmc_tm_count}
\title{Retrieve the number of database links from Europe PMC publication database}
\usage{
epmc_tm_count(ext_id = NULL, data_src = "med")
}
\arguments{
\item{ext_id}{character, publication identifier}

\item{data_src}{character, data source, by default Pubmed/MedLine index will
be searched.}
}
\value{
data.frame with counts for each semantic type
}
\description{
This function returns the number of database links for each EBI database from
  Europe PMC RESTful Web Service.
}
\details{
Europe PMC supports the following semantic types:
    \describe{
    \item{ACCESSION}{accession IDs for DNA or protein sequences}
    \item{CHEMICAL}{chemicals}
    \item{DISEASE}{diseases}
    \item{EFO}{Experimental Factor Ontology
      (\url{http://www.ebi.ac.uk/efo/})}
    \item{GENE_PROTEIN}{gene proteins}
    \item{GO_TERM}{Gene Ontology Terms (\url{http://geneontology.org/})}
    \item{ORGANISM}{organism}
    }
}
\examples{
  \dontrun{
  epmc_tm_count("PMC4340542", data_src = "pmc")
  }
}

