% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/label_eurostat.R
\name{label_eurostat}
\alias{label_eurostat}
\alias{label_eurostat_tables}
\alias{label_eurostat_vars}
\title{Get definitions for Eurostat codes from Eurostat dictionaries}
\usage{
label_eurostat(x, dic = NULL)

label_eurostat_vars(x)

label_eurostat_tables(x)
}
\arguments{
\item{x}{a vector or a data.frame.}

\item{dic}{a string (vector) naming eurostat dictionary or dictionaries.
If \code{NULL} (default) dictionry names taken from column names of
the data.frame.}
}
\value{
a vector or a data.frame.
}
\description{
A string or a factor vector of codes returns a corresponding
vector of definitions. For vectors a dictionary name have to be supplied.
For data.frames dictonary names are taken from column names.
"time" and "values" columns are returned as they were, so you can supply
data.frame from \code{\link{get_eurostat}} and get data.frame with
definitions instead of codes.
}
\section{Functions}{
\itemize{
\item \code{label_eurostat_vars}: Get definitions for variable (column) names

\item \code{label_eurostat_tables}: Get definitions for table names
}}
\examples{
\dontrun{
   lp <- get_eurostat("nama_aux_lp")
   lpl <- label_eurostat_vars(lp)
   str(lpl)
   label_eurostat_vars(names(lp))
   label_eurostat_tables("nama_aux_lp")
 }
}
\author{
Janne Huovari <janne.huovari@ptt.fi>
}

