% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pseudoglm-methods.R
\name{residuals.pseudoglm}
\alias{residuals.pseudoglm}
\title{Pseudo-observation scaled residuals}
\usage{
\method{residuals}{pseudoglm}(object, type = NULL, ...)
}
\arguments{
\item{object}{A pseudoglm object, as returned by \link{cumincglm} or
\link{rmeanglm}}

\item{type}{Either "scaled" (the default for cumulative incidence outcomes)
or one of the types available in \link[stats]{residuals.glm} for restricted mean outcomes, with the default being "deviance".}

\item{...}{Arguments passed on to \link[stats]{residuals.glm}.}
}
\value{
A numeric vector of residuals
}
\description{
Computes residuals according to the recommendations of Pohar-Perme and
Andersen (2009) <doi: 10.1002/sim.3401>.
}
\details{
The scaled residuals are computed as \deqn{\hat{\epsilon}_i =
  \frac{\hat{E}(V_i) - \hat{Y}_i}{\sqrt{\hat{Y}_i (1 - \hat{Y}_i)}}} When the
  outcome is the cumulative incidence, the denominator corresponds to an
  estimate of the standard error of the conditional estimate of the outcome
  in the absence of censoring. For the restricted mean, no such rescaling is
  done and the computation is passed off to \link[stats]{residuals.glm}.
}
\references{
Perme MP, Andersen PK. Checking hazard regression models using
  pseudo-observations. Stat Med. 2008;27(25):5309-5328.
  <doi:10.1002/sim.3401>
}
