# eventstudies

[![Build Status](https://travis-ci.org/nipfpmf/eventstudies.svg?branch=master)](https://travis-ci.org/nipfpmf/eventstudies)

An R package for conducting event studies and a platform for
methodological research on event studies.

## Installation

### Stable version
**Release notes**: https://github.com/nipfpmf/eventstudies/releases/tag/v1.2
```R
install.packages("eventstudies")
## OR
devtools::install_github("nipfpmf/eventstudies", ref="v1.2")
```

### Latest version
```R
devtools::install_github("nipfpmf/eventstudies", ref="master")
```

## Usage

```R
data("SplitDates", package = "eventstudies")
data("StockPriceReturns", package = "eventstudies")
data("OtherReturns", package = "eventstudies")

es <- eventstudies::eventstudy(firm.returns = StockPriceReturns,
         event.list = SplitDates,
         event.window = 7,
         type = "marketModel",
         to.remap = TRUE,
         remap = "cumsum",
         inference = TRUE,
         inference.strategy = "bootstrap",
         model.args = list(
             market.returns = OtherReturns[, "NiftyIndex"]
             )
         )
plot(es)
```

## Help
```R
?eventstudy
vignette("eventstudies", package = "eventstudies")
examples("eventstudy", package = "eventstudies")
```

## Contributing

1. Fork it!
2. Create your feature branch: `git checkout -b my-new-feature`
3. Commit your changes: `git commit -am 'Add some feature'`
4. Push to the branch: `git push origin my-new-feature`
5. Submit a pull request

## History

This repository was moved from R-forge before the release of v1.2:

<https://r-forge.r-project.org/projects/eventstudies>

## License

GPL-2
