% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/evmixdiag.r
\name{evmix.diag}
\alias{evmix.diag}
\alias{rlplot}
\alias{qplot}
\alias{pplot}
\alias{densplot}
\alias{rlplot}
\alias{evmix.diag}
\alias{qplot}
\alias{pplot}
\alias{densplot}
\alias{qplot}
\alias{evmix.diag}
\alias{rlplot}
\alias{pplot}
\alias{densplot}
\alias{pplot}
\alias{evmix.diag}
\alias{rlplot}
\alias{qplot}
\alias{densplot}
\alias{densplot}
\alias{evmix.diag}
\alias{rlplot}
\alias{qplot}
\alias{pplot}
\title{Diagnostic Plots for Extreme Value Mixture Models}
\usage{
evmix.diag(modelfit, upperfocus = TRUE, alpha = 0.05, N = 1000,
  legend = FALSE, ...)

rlplot(modelfit, upperfocus = TRUE, alpha = 0.05, N = 1000,
  legend = TRUE, rplim = NULL, rllim = NULL, ...)

qplot(modelfit, upperfocus = TRUE, alpha = 0.05, N = 1000,
  legend = TRUE, ...)

pplot(modelfit, upperfocus = TRUE, alpha = 0.05, N = 1000,
  legend = TRUE, ...)

densplot(modelfit, upperfocus = TRUE, legend = TRUE, ...)
}
\arguments{
\item{modelfit}{fitted extreme value mixture model object}

\item{upperfocus}{logical, should plot focus on upper tail?}

\item{alpha}{significance level over range (0, 1), or \code{NULL} for no CI}

\item{N}{number of Monte Carlo simulation for CI (N>=10)}

\item{legend}{logical, should legend be included}

\item{...}{further arguments to be passed to the plotting functions}

\item{rplim}{return period range}

\item{rllim}{return level range}
}
\value{
\code{\link[evmix:evmix.diag]{rlplot}} gives the return level plot, 
\code{\link[evmix:evmix.diag]{qplot}} gives the Q-Q plot,
\code{\link[evmix:evmix.diag]{pplot}} gives the P-P plot,
\code{\link[evmix:evmix.diag]{densplot}} gives density plot and
\code{\link[evmix:evmix.diag]{evmix.diag}} gives the collection of all 4.
}
\description{
The classic four diagnostic plots for evaluating extreme value mixture models: 
  1) return level plot, 2) Q-Q plot, 3) P-P plot and 4) density plot. Each plot is available
  individually or as the usual 2x2 collection.
}
\details{
Model diagnostics are available for all the fitted extreme mixture models in the 
\code{\link[evmix:evmix-package]{evmix}} package. These \code{modelfit} is output by all the fitting 
functions, e.g. \code{\link[evmix:fgpd]{fgpd}} and \code{\link[evmix:fnormgpd]{fnormgpd}}.

Consistent with \code{\link[evd:plot.uvevd]{plot}} function in the 
\code{\link[evd:gpd]{evd}} library the \code{\link[stats:ppoints]{ppoints}} to 
estimate the empirical cumulative probabilities. The default behaviour of this
function is to use \deqn{(i-0.5)/n} as the estimate for the \eqn{i}th order statistic of
the given sample of size \eqn{n}.

The return level plot has the quantile (\eqn{q} where \eqn{P(X \ge q)=p} on
the \eqn{y}-axis, for a particular survival probability \eqn{p}. The return period
\eqn{t=1/p} is shown on the \eqn{x}-axis. The return level is given by:
   \deqn{q = u + \sigma_u [(\phi_u t)^\xi - 1]/\xi}
for \eqn{\xi\ne 0}. But in the case of \eqn{\xi = 0} this simplifies to 
 \deqn{q = u + \sigma_u log(\phi_u t)}
which is linear when plotted against the return period on a logarithmic scale. The special
case of exponential/Type I (\eqn{\xi=0}) upper tail behaviour will be linear on
this scale. This is the same tranformation as in the GPD/POT diagnostic plot function
\code{\link[evd:plot.uvevd]{plot.uvevd}} in the \code{\link[evd:plot.uvevd]{evd}} package,
from which these functions were derived.

The crosses are the empirical quantiles/return levels (i.e. the ordered sample data)
against their corresponding transformed empirical return period (from 
\code{\link[stats:ppoints]{ppoints}}). The solid line is the theoretical return level
(quantile) function using the estimated parameters. The estimated threshold 
\code{u} and tail fraction \code{phiu} are shown. For the two tailed models both
thresholds \code{ul} and \code{ur} and corresponding tail fractions 
\code{phiul} and \code{phiur} are shown. The approximate pointwise confidence intervals
for the quantiles are obtained by Monte Carlo simulation using the estimated parameters.
Notice that these intervals ignore the parameter estimation uncertainty.

The Q-Q and P-P plots have the empirical values on the \eqn{y}-axis and theoretical values
from the fitted model on the \eqn{x}-axis.

The density plot provides a histogram of the sample data overlaid with the fitted density
and a standard kernel density estimate using the \code{\link[stats:density]{density}}
function. The default settings for the \code{\link[stats:density]{density}} function are used.
Note that for distributions with bounded support (e.g. GPD) with high density near the
boundary standard kernel density estimators exhibit a negative bias due to leakage past
the boundary. So in this case they should not be taken too seriously.

For the kernel density estimates (i.e. \code{kden} and \code{bckden}) there is no threshold, 
so no upper tail focus is carried out.

See \code{\link[evd:plot.uvevd]{plot.uvevd}} for more detailed explanations of these
types of plots.
}
\note{
For all mixture models the missing values are removed by the fitting functions 
(e.g. \code{\link[evmix:fnormgpd]{fnormgpd}} and \code{\link[evmix:fgng]{fgng}}).
However, these are retained in the GPD fitting \code{\link[evmix:fgpd]{fgpd}}, as they 
are interpreted as values below the threshold.

By default all the plots focus in on the upper tail, but they can be used to display 
the fit over the entire range of support.

You cannot pass \code{xlim} or \code{ylim} to the plotting functions via \code{...}

Error checking of the inputs (e.g. invalid probabilities) is carried out and
will either stop or give warning message as appropriate.
}
\section{Acknowledgments}{
 Based on the GPD/POT diagnostic function \code{\link[evd:plot.uvevd]{plot.uvevd}} in the \code{\link[evd:plot.uvevd]{evd}} package for which Stuart Coles' and Alec Stephenson's 
contributions are gratefully acknowledged.
They are designed to have similar syntax and functionality to simplify the transition for users of these packages.
}

\examples{
\dontrun{
set.seed(1)

x = sort(rnorm(1000))
fit = fnormgpd(x)
evmix.diag(fit)

# repeat without focussing on upper tail
par(mfrow=c(2,2))
rlplot(fit, upperfocus = FALSE)
qplot(fit, upperfocus = FALSE)
pplot(fit, upperfocus = FALSE)
densplot(fit, upperfocus = FALSE)
}

}
\references{
\url{http://en.wikipedia.org/wiki/Q-Q_plot}

\url{http://en.wikipedia.org/wiki/P-P_plot}

Scarrott, C.J. and MacDonald, A. (2012). A review of extreme value
threshold estimation and uncertainty quantification. REVSTAT - Statistical
Journal 10(1), 33-59. Available from \url{http://www.ine.pt/revstat/pdf/rs120102.pdf}

Coles S.G. (2004). An Introduction to the Statistical Modelling of Extreme Values.
Springer-Verlag: London.
}
\seealso{
\code{\link[stats:ppoints]{ppoints}}, \code{\link[evd:plot.uvevd]{plot.uvevd}} and
  \code{\link[ismev:gpd.diag]{gpd.diag}}.
}
\author{
Yang Hu and Carl Scarrott \email{carl.scarrott@canterbury.ac.nz}
}
