% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simulation.R
\name{simulate_sessions}
\alias{simulate_sessions}
\title{Simulation of EV sessions}
\usage{
simulate_sessions(
  evmodel,
  sessions_day,
  user_profiles,
  charging_powers,
  dates,
  resolution
)
}
\arguments{
\item{evmodel}{object of class \code{evmodel} built with \code{{evprof}}
(see this \href{https://mcanigueral.github.io/evprof/articles/evmodel.html}{link} for more information)}

\item{sessions_day}{tibble with variables \code{time_cycle} (names corresponding to \code{evmodel$models$time_cycle}) and \code{n_sessions} (number of daily sessions per day for each time-cycle model)}

\item{user_profiles}{tibble with variables \code{time_cycle}, \code{profile}, \code{ratio} and optionally \code{power}.
It can also be \code{NULL} to use the \code{evmodel} original user profiles distribution.
The powers must be in kW and the ratios between 0 and 1.
The user profiles with a value of \code{power} will be simulated with this specific charging power.
If \code{power} is \code{NA} then it is simulated according to the ratios of next parameter \code{charging_powers}.}

\item{charging_powers}{tibble with variables \code{power} and \code{ratio}.
The powers must be in kW and the ratios between 0 and 1.
This is used to simulate the charging power of user profiles without a specific charging power in \code{user_profiles} parameter.}

\item{dates}{date sequence that will set the time frame of the simulated sessions}

\item{resolution}{integer, time resolution (in minutes) of the sessions datetime variables}
}
\value{
tibble
}
\description{
Simulate EV charging sessions given the \code{evmodel} object and other contextual parameters.
}
\details{
Some adaptations have been done to the output of the Gaussian models:
the minimum simulated energy is considered to be 1 kWh, while the minimum
connection duration is 30 minutes.
}
\examples{
library(dplyr)
library(lubridate)

# Get the example `evmodel`
ev_model <- evsim::california_ev_model

# Simulate EV charging sessions, considering that the Worktime sessions
# during Workdays have 11 kW, while all Visit sessions charge at 3.7kW or
# 11kW, with a distribution of 30\% and 70\% respectively.

simulate_sessions(
  ev_model,
  sessions_day = tibble(
    time_cycle = c("Workday", "Weekend"),
    n_sessions = c(15, 10)
  ),
  user_profiles = tibble(
    time_cycle = c("Workday", "Workday", "Weekend"),
    profile = c("Visit", "Worktime", "Visit"),
    ratio = c(0.5, 0.5, 1),
    power = c(NA, 11, NA)
  ),
  charging_powers = tibble(
    power = c(3.7, 11),
    ratio = c(0.3, 0.7)
  ),
  dates = seq.Date(today(), today()+days(4), length.out = 4),
  resolution = 15
)

}
