% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_excerpts.R
\name{get_excerpts}
\alias{get_excerpts}
\title{Clone the Excerpts Code from \url{github.com}}
\usage{
get_excerpts(directory = get_excerpts_path(), branch = "devel",
  force = FALSE, remove_dot_git = TRUE)
}
\arguments{
\item{directory}{Where to clone to.}

\item{branch}{See \code{\link[git2r:clone]{git2r::clone}}.}

\item{force}{Overwrite the directory?}

\item{remove_dot_git}{Remove the .git/ from the clone?}
}
\value{
The status of\code{\link[git2r:clone]{git2r::clone}}, or,
if \code{remove_dot_git} is TRUE, the \code{\link{capture.output}} thereof.
}
\description{
Get excerpts' the latest commit to branch master on 
\url{https://github.com/fvafrCU/excerpts/}.
Meant for development only.
}
\examples{
path <- file.path(tempdir(), "excerpts")
get_excerpts(directory = path, force = TRUE)
\dontrun{print(set_excertps_path(path = path))}
}
