% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/coollex.R
\name{coollex}
\alias{coollex}
\title{Computing combinations with the Coollex algorithm}
\usage{
coollex(ind, i1, i2)
}
\arguments{
\item{ind}{A binary string encoding the selected elements from a set.}

\item{i1}{An integer counter. This counter (and the next) are used to make this implementation of the coollex algorithm 'loopless'. Initial values should be assigned as explained in the \code{description} section above. Later values are provided from earlier iterations of the function.}

\item{i2}{A second integer counter.}
}
\value{
A binary string encoding the next combination.
}
\description{
Computes the next combination in a sequence using the Coollex algortihm. When computing the combinations of k elements taken from n elements, the algorithm should be initialized by setting \code{ind<-c(rep(1,k),rep(0,n-k))} and \code{attr(ind,"i1")<-attr(ind,"i2")<-k}.
}
\examples{
n<-4
k<-2
indi<-c(rep(1,k),rep(0,n-k))
attr(indi,"i1")<-attr(indi,"i2")<-k
allinds<-indi
for(i in 2:choose(n,k)){
 indi<-coollex(indi,attr(indi,"i1"),attr(indi,"i2"))
 allinds<-rbind(allinds,indi)
}
allinds
}
