% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/9-deprecated.R
\name{GSE2eSet}
\alias{GSE2eSet}
\title{Convert GSE to eSet}
\usage{
GSE2eSet(gse, colBy, colID)
}
\arguments{
\item{gse}{A GSE data object retrieved using GEOquery.}

\item{colBy}{A character string. The GSE column name that contains the feature value.
If missing, function will prompt user for a column name after previewing options.}

\item{colID}{A character string. The GSE column name that contains the feature identity.
If missing, function will prompt user for a column name after previewing options.}
}
\value{
An \code{ExpressionSet} object.
}
\description{
A convenience function that builds an \code{eSet} object from a GSE data source.
}
\details{
The NCBI GEO hosts files in GSE or GDS format, the latter of which exists as a curated version
 the former. These GDS data files easily convert to an  \code{ExpressionSet} (abbreviated
 \code{eSet}) object using the \code{GDS2eSet} function available from the GEOquery package.
 However, not all GSE data files have a corresponding GDS data file available. To convert GSE
 data files into \code{eSet} objects, \code{exprso} provides this convenience function.

However, the user should note that GSE data files do not always get stored in an easy to parse format.
 Although this function has worked successfully with some GSE data files, we cannot make any
 guarantee that it will work for all GSE data files.

To acquire GSE data files, use the function \code{getGEO} from the GEOquery package (e.g.,
 \code{getGEO("GSExxxxx", GSEMatrix = FALSE)}). For more information, see the GEOquery package.
}
\seealso{
\code{\link{ExprsArray-class}}, \code{\link{arrayExprs}}
}
