% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/do_repeat.R
\name{do_repeat}
\alias{do_repeat}
\alias{do_repeat}
\alias{.do_repeat}
\alias{as_is}
\title{Repeats the same transformations on a specified set of variables/values}
\usage{
do_repeat(data, ...)

.do_repeat(...)

as_is(...)
}
\arguments{
\item{data}{data.frame/list. If \code{data} is list then \code{do_repeat}
will be applied to each element of the list.}

\item{...}{stand-in name(s) followed by equals sign and a vector/list of 
replacement variables or values. They can be numeric/characters or 
variables names. Names at the top-level can be unquoted (non-standard 
evaluation). Quoted characters also considered as variables names. To avoid
this behavior use \code{as_is} function. For standard evaluation of 
parameters you can surround them by round brackets. Also you can use 
\link{\%to\%} operator and other \link{criteria} functions. Last argument
should be expression in curly brackets which will be evaluated in the scope
of data.frame \code{data}. See examples.}
}
\value{
transformed data.frame \code{data}
}
\description{
Repeats the same transformations on a specified set of variables/values
}
\details{
There is a special constant \code{.N} which equals to number of 
  cases in \code{data} for usage in expression inside \code{do_repeat}. Also 
  there are a variables \code{.item_num} which is equal to the current 
  iteration number and \code{.item_value} which is named list with current
  stand-in variables values.
}
\examples{
data(iris)
scaled_iris = do_repeat(iris, 
                        i = Sepal.Length \%to\% Petal.Width, 
                        {
                            i = scale(i)
                        })
head(scaled_iris)

# several stand-in names and standard evaluattion
old_names = qc(Sepal.Length, Sepal.Width, Petal.Length, Petal.Width)
new_names = paste0("scaled_", old_names)
scaled_iris = do_repeat(iris, 
                        orig = ((old_names)), 
                        scaled = ((new_names)), 
                        {
                            scaled = scale(orig)
                        })
head(scaled_iris)

# numerics
new_df = data.frame(id = 1:20)
# note the automatic creation of the sequence of variables
new_df = do_repeat(new_df, 
                   item = i1 \%to\% i3, 
                   value = c(1, 2, 3), 
                   {
                       item = value
                   })
head(new_df)

# the same result with internal variable '.item_num'
new_df = data.frame(id = 1:20)
new_df = do_repeat(new_df, 
                   item = i1 \%to\% i3,
                   {
                       item = .item_num
                   })
head(new_df)

# functions
set.seed(123)
new_df = data.frame(id = 1:20)
new_df = do_repeat(new_df, 
                   item = c(i1, i2, i3), 
                   fun = c("rnorm", "runif", "rexp"), 
                   {
                       item = fun(.N)
                   })
head(new_df)


}
\seealso{
\link{compute}, \link{do_if}
}
