% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mixture-of-normal-distributions.R
\name{NormalMix}
\alias{NormalMix}
\alias{dmixnorm}
\alias{pmixnorm}
\alias{rmixnorm}
\title{Mixture of normal distributions}
\usage{
dmixnorm(x, mean, sd, alpha, log = FALSE)

pmixnorm(q, mean, sd, alpha, lower.tail = TRUE, log.p = FALSE)

rmixnorm(n, mean, sd, alpha)
}
\arguments{
\item{x, q}{vector of quantiles.}

\item{mean}{matrix (or vector) of means.}

\item{sd}{matrix (or vector) of standard deviations.}

\item{alpha}{matrix (or vector) of mixing proportions;
mixing proportions need to sum up to 1.}

\item{log, log.p}{logical; if TRUE, probabilities p are given as log(p).}

\item{lower.tail}{logical; if TRUE (default), probabilities are \eqn{P[X \le x]}
otherwise, \eqn{P[X > x]}.}

\item{n}{number of observations. If \code{length(n) > 1},
the length is taken to be the number required.}

\item{p}{vector of probabilities.}
}
\description{
Density, distribution function and random generation
for the mixture of normal distributions.
}
\details{
Probability density function
\deqn{
f(x) = \alpha_1 f_1(x; \mu_1, \sigma_1) + \dots + \alpha_k f_k(x; \mu_k, \sigma_k)
}{
f(x) = \alpha[1] * f1(x; \mu[1], \sigma[1]) + \dots + \alpha[k] * fk(x; \mu[k], \sigma[k])
}

Cumulative distribution function
\deqn{
F(x) = \alpha_1 F_1(x; \mu_1, \sigma_1) + \dots + \alpha_k F_k(x; \mu_k, \sigma_k)
}{
F(x) = \alpha[1] * F1(x; \mu[1], \sigma[1]) + \dots + \alpha[k] * Fk(x; \mu[k], \sigma[k])
}

where \eqn{\sum_i \alpha_i = 1}{sum(\alpha[i]) == 1}.
}
\examples{

x <- rmixnorm(1e5, c(0.5, 3, 6), c(3, 1, 1), c(1/3, 1/3, 1/3))
xx <- seq(-20, 20, by = 0.1)
hist(x, 100, freq = FALSE)
lines(xx, dmixnorm(xx, c(0.5, 3, 6), c(3, 1, 1), c(1/3, 1/3, 1/3)), col = "red")
hist(pmixnorm(x, c(0.5, 3, 6), c(3, 1, 1), c(1/3, 1/3, 1/3)))
plot(ecdf(x))
lines(xx, pmixnorm(xx, c(0.5, 3, 6), c(3, 1, 1), c(1/3, 1/3, 1/3)), col = "red", lwd = 2)

}
\keyword{distribution}

