/*
 * Decompiled with CFR 0.152.
 */
package org.extratrees;

import java.util.ArrayList;
import org.extratrees.AbstractTrees;
import org.extratrees.FactorBinaryTree;
import org.extratrees.Matrix;
import org.extratrees.ShuffledIterator;

public class FactorExtraTrees
extends AbstractTrees<FactorBinaryTree> {
    Matrix input;
    int[] output;
    int nFactors;
    static double zero = 1.0E-6;
    ArrayList<Integer> cols;
    int numRandomCuts = 1;
    boolean evenCuts = false;

    public FactorExtraTrees(Matrix matrix, int[] nArray) {
        int n;
        if (matrix.nrows != nArray.length) {
            throw new IllegalArgumentException("Input and output do not have same length.");
        }
        this.input = matrix;
        this.output = nArray;
        this.nFactors = 1;
        for (n = 0; n < nArray.length; ++n) {
            if (nArray[n] < 0) {
                throw new RuntimeException("Bug: negative output (factor) values.");
            }
            if (this.nFactors > nArray[n]) continue;
            this.nFactors = nArray[n] + 1;
        }
        this.cols = new ArrayList(matrix.ncols);
        for (n = 0; n < matrix.ncols; ++n) {
            this.cols.add(n);
        }
    }

    public int getnFactors() {
        return this.nFactors;
    }

    public void setnFactors(int n) {
        this.nFactors = n;
    }

    public boolean isEvenCuts() {
        return this.evenCuts;
    }

    public void setEvenCuts(boolean bl) {
        this.evenCuts = bl;
    }

    public int getNumRandomCuts() {
        return this.numRandomCuts;
    }

    public void setNumRandomCuts(int n) {
        this.numRandomCuts = n;
    }

    public ArrayList<FactorBinaryTree> buildTrees(int n, int n2, int n3, int[] nArray) {
        ArrayList<FactorBinaryTree> arrayList = new ArrayList<FactorBinaryTree>(n3);
        ShuffledIterator<Integer> shuffledIterator = new ShuffledIterator<Integer>(this.cols);
        for (int i = 0; i < n3; ++i) {
            arrayList.add(this.buildTree(n, n2, nArray, shuffledIterator));
        }
        return arrayList;
    }

    public static int getValue(ArrayList<FactorBinaryTree> arrayList, double[] dArray, int n) {
        int[] nArray = new int[n];
        for (FactorBinaryTree factorBinaryTree : arrayList) {
            int n2 = factorBinaryTree.getValue(dArray);
            nArray[n2] = nArray[n2] + 1;
        }
        return FactorExtraTrees.getMaxIndex(nArray);
    }

    public static double getValue(ArrayList<FactorBinaryTree> arrayList, double[] dArray, int n, int n2) {
        int[] nArray = new int[n2];
        for (FactorBinaryTree factorBinaryTree : arrayList) {
            int n3 = factorBinaryTree.getValue(dArray, n);
            nArray[n3] = nArray[n3] + 1;
        }
        return FactorExtraTrees.getMaxIndex(nArray);
    }

    public static int getMaxIndex(int[] nArray) {
        int n = -1;
        int n2 = Integer.MIN_VALUE;
        for (int i = 0; i < nArray.length; ++i) {
            if (nArray[i] <= n2) continue;
            n2 = nArray[i];
            n = i;
        }
        return n;
    }

    public int[] getValues(Matrix matrix) {
        return FactorExtraTrees.getValues(this.trees, matrix, this.nFactors);
    }

    public static int[] getValues(ArrayList<FactorBinaryTree> arrayList, Matrix matrix, int n) {
        int[] nArray = new int[matrix.nrows];
        double[] dArray = new double[matrix.ncols];
        for (int i = 0; i < matrix.nrows; ++i) {
            for (int j = 0; j < matrix.ncols; ++j) {
                dArray[j] = matrix.get(i, j);
            }
            nArray[i] = FactorExtraTrees.getValue(arrayList, dArray, n);
        }
        return nArray;
    }

    @Override
    public FactorBinaryTree buildTree(int n, int n2) {
        int[] nArray = new int[this.output.length];
        for (int i = 0; i < nArray.length; ++i) {
            nArray[i] = i;
        }
        ShuffledIterator<Integer> shuffledIterator = new ShuffledIterator<Integer>(this.cols);
        return this.buildTree(n, n2, nArray, shuffledIterator);
    }

    public static double getGiniIndex(int[] nArray) {
        int n = 0;
        int n2 = 0;
        for (int i = 0; i < nArray.length; ++i) {
            n += nArray[i] * nArray[i];
            n2 += nArray[i];
        }
        return 1.0 - (double)n / (double)(n2 * n2);
    }

    public FactorBinaryTree buildTree(int n, int n2, int[] nArray, ShuffledIterator<Integer> shuffledIterator) {
        if (nArray.length < n) {
            return this.makeLeaf(nArray);
        }
        shuffledIterator.reset();
        int n3 = 0;
        int n4 = -1;
        double d = Double.POSITIVE_INFINITY;
        boolean bl = false;
        boolean bl2 = false;
        int n5 = 0;
        int n6 = 0;
        double d2 = Double.NaN;
        while (shuffledIterator.hasNext()) {
            int n7 = shuffledIterator.next();
            double d3 = Double.POSITIVE_INFINITY;
            double d4 = Double.NEGATIVE_INFINITY;
            for (int i = 0; i < nArray.length; ++i) {
                double d5 = this.input.get(nArray[i], n7);
                if (d5 < d3) {
                    d3 = d5;
                }
                if (!(d5 > d4)) continue;
                d4 = d5;
            }
            if (d4 - d3 < zero) continue;
            double d6 = d4 - d3;
            for (int i = 0; i < this.numRandomCuts; ++i) {
                double d7;
                double d8;
                if (this.evenCuts) {
                    double d9 = d3 + (double)i * d6 / (double)this.numRandomCuts;
                    double d10 = d3 + (double)(i + 1) * d6 / (double)this.numRandomCuts;
                    d8 = Math.random() * (d10 - d9) + d9;
                } else {
                    d8 = Math.random() * d6 + d3;
                }
                int n8 = 0;
                int n9 = 0;
                int[] nArray2 = new int[this.nFactors];
                int[] nArray3 = new int[this.nFactors];
                for (int j = 0; j < nArray.length; ++j) {
                    if (this.input.get(nArray[j], n7) < d8) {
                        ++n8;
                        int n10 = this.output[nArray[j]];
                        nArray2[n10] = nArray2[n10] + 1;
                        continue;
                    }
                    ++n9;
                    int n11 = this.output[nArray[j]];
                    nArray3[n11] = nArray3[n11] + 1;
                }
                double d11 = FactorExtraTrees.getGiniIndex(nArray2);
                double d12 = d11 * (double)n8 + (d7 = FactorExtraTrees.getGiniIndex(nArray3)) * (double)n9;
                if (!(d12 < d)) continue;
                d = d12;
                n4 = n7;
                d2 = d8;
                bl = d11 < zero * zero;
                bl2 = d7 < zero * zero;
                n5 = n8;
                n6 = n9;
            }
            if (++n3 < n2) continue;
            break;
        }
        if (n4 < 0) {
            return this.makeLeaf(nArray);
        }
        int[] nArray4 = new int[n5];
        int[] nArray5 = new int[n6];
        int n12 = 0;
        int n13 = 0;
        for (int i = 0; i < nArray.length; ++i) {
            if (this.input.get(nArray[i], n4) < d2) {
                nArray4[n12] = nArray[i];
                ++n12;
                continue;
            }
            nArray5[n13] = nArray[i];
            ++n13;
        }
        FactorBinaryTree factorBinaryTree = new FactorBinaryTree();
        factorBinaryTree.column = n4;
        factorBinaryTree.threshold = d2;
        factorBinaryTree.nSuccessors = nArray.length;
        factorBinaryTree.left = bl ? this.makeLeaf(nArray4) : this.buildTree(n, n2, nArray4, shuffledIterator);
        factorBinaryTree.right = bl2 ? this.makeLeaf(nArray5) : this.buildTree(n, n2, nArray5, shuffledIterator);
        return factorBinaryTree;
    }

    public FactorBinaryTree makeLeaf(int[] nArray) {
        FactorBinaryTree factorBinaryTree = new FactorBinaryTree();
        factorBinaryTree.value = 0;
        factorBinaryTree.nSuccessors = nArray.length;
        int[] nArray2 = new int[this.nFactors];
        for (int i = 0; i < nArray.length; ++i) {
            int n = this.output[nArray[i]];
            nArray2[n] = nArray2[n] + 1;
        }
        factorBinaryTree.value = FactorExtraTrees.getMaxIndex(nArray2);
        return factorBinaryTree;
    }
}

