% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{amd}
\alias{amd}
\title{Real life data of patients with neovascular AMD}
\format{
A data frame with 40764 rows and 7 variables:
\describe{
\item{Id}{Anonymized patient identifier}
\item{Eye}{Left or right eye of patient (0 = right, 1 = left)}
\item{FollowupDays}{Days after date of first appointment (0 = first appointment)}
\item{BaselineAge}{Age (years) at day of first appointment}
\item{Gender}{Gender of patient (0 = male, 1 = female)}
\item{VA_ETDRS_Letters}{Visual acuity in Early Treatment Diabetic Retinopathy Study letters}
\item{InjectionNumber}{Current number of injection at appointment date}
}
}
\source{
\url{https://datadryad.org/stash/dataset/doi:10.5061/dryad.97r9289}
}
\usage{
data("amd")
}
\description{
A dataset containing anonymized real life human subjects data on eyes with
treatment naive neovascular age-related macular degeneration (AMD),
which underwent intravitreal anti-VEGF therapy with ranibizumab
and/or aflibercept.
}
\details{
The data was collected in Moorfields Eye Hospital, London, UK.
(Information governance sign off Moorfields Eye Hospital 19/07/2018)

Data was accessed on the 25th May 2020
}
\section{Spurious data entries}{

Note there are erroneous visual acuity entries in this data set which I
noticed during the work on this package. The data set curator has been
contacted and it it was concluded that these were erroneous entries
in the original medical health records. I decided to keep the
values in the data set and wait for the final decision how to proceed
from the data set curator (if they are going to replace it with missing
values or not). I believe this is a great example for the
challenges of real life data and a reminder to remain
vigilant when doing data analysis.
}

\keyword{datasets}
