% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/eyelink_parser.R
\name{read.asc}
\alias{read.asc}
\title{Read EyeLink ASC Files}
\usage{
read.asc(fname, samples = TRUE, events = TRUE, parse_all = FALSE)
}
\arguments{
\item{fname}{\code{character} vector indicating the name of the .asc file to import.}

\item{samples}{\code{logical} indicating whether raw sample data should be imported. Defaults
to \code{TRUE}.}

\item{events}{\code{logical} indicating whether event data (e.g. saccades, blinks, messages,
etc.) should be imported. Defaults to \code{TRUE}.}

\item{parse_all}{\code{logical} indicating whether samples/events not within START/END
blocks should be parsed. Defaults to \code{FALSE}.}
}
\value{
A \code{list} of \code{\link[tibble]{tibble}}s containing data from the .asc file.
}
\description{
Imports data from EyeLink ASC files into (relatively) tidy data frames for analysis and
visualization. Event data and/or raw sample data from the files can be imported, along with
information about the tracker hardware and configuration. All data is divided into numbered
blocks using the "START" and "END" messages in the ASC file.
}
\details{
ASC files can contain anywhere between 125 to 2000 rows of samples for every second of recording,
meaning that the resulting files can be very large (1.2 million rows of samples for 20 minutes at
1000Hz). As a result, importing some ASC files can be slow, and the resulting data frames can
take up 100's of MB of memory. To speed up import and greatly reduce memory load, you can choose
to ignore raw samples and only import events by setting the samples parameter to \code{FALSE}.

This function returns a list containing the following possible data frames: \describe{
  \item{\code{raw}}{Raw sample data}
  \item{\code{sacc}}{Saccade end events}
  \item{\code{fix}}{Fixation end events}
  \item{\code{blinks}}{Blink end events}
  \item{\code{msg}}{Messages sent or received by the tracker}
  \item{\code{input}}{Input port (TTL) events}
  \item{\code{button}}{Button box / gamepad events}
  \item{\code{info}}{Tracker settings/configuration metadata}
}
The names of the columns in these data frames correspond to column names given in the ASC
section of the EyeLink 1000 User's Guide.

Note that this function cannot import EDFs directly; they must be converted to plain-text ASC
using the edf2asc utility before importing.
}
\examples{
# Example file from SR research that ships with the package
fpath <- system.file("extdata/mono500.asc.gz", package = "eyelinker")
dat <- read.asc(fpath)
plot(dat$raw$time, dat$raw$xp, xlab = "Time (ms)", ylab = "Eye position along x-axis (pix)")

}
\author{
Simon Barthelme & Austin Hurst
}
