% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pipeline-glassbox.R
\name{glassbox}
\alias{glassbox}
\title{The opinionated "glass box" \code{eyeris} pipeline}
\usage{
glassbox(
  file,
  interactive_preview = FALSE,
  preview_n = 3,
  preview_duration = 5,
  preview_window = NULL,
  verbose = TRUE,
  ...,
  confirm = deprecated(),
  num_previews = deprecated(),
  detrend_data = deprecated(),
  skip_detransient = deprecated()
)
}
\arguments{
\item{file}{An SR Research EyeLink \code{.asc} file generated by the official
EyeLink \code{edf2asc} command}

\item{interactive_preview}{A flag to indicate whether to run the \code{glassbox}
pipeline autonomously all the way through (set to \code{FALSE} by default), or to
interactively provide a visualization after each pipeline step, where you
must also indicate "(y)es" or "(n)o" to either proceed or cancel the
current \code{glassbox} pipeline operation (set to \code{TRUE})}

\item{preview_n}{Number of random example "epochs" to generate for
previewing the effect of each preprocessing step on the pupil timeseries}

\item{preview_duration}{Time in seconds of each randomly selected preview}

\item{preview_window}{The start and stop raw timestamps used to subset the
preprocessed data from each step of the \code{eyeris} workflow for visualization.
Defaults to NULL, meaning random epochs as defined by \code{preview_n} and
\code{preview_duration} will be plotted. To override the random epochs, set
\code{preview_window} here to a vector with relative start and stop times (in
seconds), for example -- \code{c(5,6)} -- to indicate the raw data from 5-6 secs
on data that were recorded at 1000 Hz). Note, the start/stop time values
indicated here are in seconds because \code{eyeris} automatically computes the
indices for the supplied range of seconds using the \verb{$info$sample.rate}
metadata in the \code{eyeris} S3 class object}

\item{verbose}{A logical flag to indicate whether to print status messages to
the console. Defaults to \code{TRUE}. Set to \code{FALSE} to suppress messages about
the current processing step and run silently}

\item{...}{Additional arguments to override the default, prescribed settings}

\item{confirm}{\strong{(Deprecated)} Use \code{interactive_preview} instead}

\item{num_previews}{\strong{(Deprecated)} Use \code{preview_n} instead}

\item{detrend_data}{\strong{(Deprecated)} A flag to indicate whether to run the
\code{detrend} step (set to \code{FALSE} by default). Detrending your pupil timeseries
can have unintended consequences; we thus recommend that users understand the
implications of detrending -- in addition to whether detrending is
appropriate for the research design and question(s) -- before using this
function}

\item{skip_detransient}{\strong{(Deprecated)} A flag to indicate whether to skip
the \code{detransient} step (set to \code{FALSE} by default). In most cases, this
should remain \code{FALSE}. For a more detailed description about likely edge
cases that would prompt you to set this to \code{TRUE}, see the docs for
\code{\link[=detransient]{detransient()}}}
}
\value{
Preprocessed pupil data contained within an object of class \code{eyeris}
}
\description{
This \code{glassbox} function (in contrast to a "black box" function where you run
it and get a result but have no (or little) idea as to how you got from input
to output) has a few primary benefits over calling each exported function
from \code{eyeris} separately.
}
\details{
First, this \code{glassbox} function provides a highly opinionated prescription of
steps and starting parameters we believe any pupillometry researcher should
use as their defaults when preprocessing pupillometry data.

Second, and not mutually exclusive from the first point, using this function
should ideally reduce the probability of accidental mishaps when
"reimplementing" the steps from the preprocessing pipeline both within and
across projects. We hope to streamline the process in such a way that you
could collect a pupillometry dataset and within a few minutes assess the
quality of those data while simultaneously running a full preprocessing
pipeline in 1-ish line of code!

Third, \code{glassbox} provides an "interactive" framework where you can evaluate
the consequences of the parameters within each step on your data in real
time, facilitating a fairly easy-to-use workflow for parameter optimization
on your particular dataset. This process essentially takes each of the
opinionated steps and provides a pre-/post-plot of the timeseries data for
each step so you can adjust parameters and re-run the pipeline until you are
satisfied with the choices of your parameters and their consequences on your
pupil timeseries data.
}
\examples{
demo_data <- eyelink_asc_demo_dataset()

# (1) examples using the default prescribed parameters and pipeline recipe

## (a) run an automated pipeline with no real-time inspection of parameters
output <- eyeris::glassbox(demo_data)

start_time <- min(output$timeseries$block_1$time_secs)
end_time <- max(output$timeseries$block_1$time_secs)

# by default, verbose = TRUE. To suppress messages, set verbose = FALSE.
plot(
  output,
  steps = c(1, 5),
  preview_window = c(start_time, end_time),
  seed = 0
)

## (b) run a interactive workflow (with confirmation prompts after each step)
\donttest{
output <- eyeris::glassbox(demo_data, interactive_preview = TRUE, seed = 0)
}

# (2) examples of overriding the default parameters
output <- eyeris::glassbox(
  demo_data,
  interactive_preview = FALSE, # TRUE to visualize each step in real-time
  deblink = list(extend = 40),
  lpfilt = list(plot_freqz = TRUE) # overrides verbose parameter
)

# to suppress messages, set verbose = FALSE in plot():
plot(output, seed = 0, verbose = FALSE)

# (3) examples of disabling certain steps
output <- eyeris::glassbox(
  demo_data,
  detransient = FALSE,
  detrend = FALSE,
  zscore = FALSE
)

plot(output, seed = 0)

}
\seealso{
\code{\link[lifecycle:deprecate_soft]{lifecycle::deprecate_warn()}}
}
