% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data_prep.R
\name{subset_by_window}
\alias{subset_by_window}
\title{Extract a subset of the dataset within a time-window in each trial.}
\usage{
subset_by_window(data, rezero = TRUE, remove = TRUE,
  window_start_msg = NULL, window_end_msg = NULL, msg_col = NULL,
  window_start_col = NULL, window_end_col = NULL,
  window_start_time = NULL, window_end_time = NULL, quiet = FALSE)
}
\arguments{
\item{data}{Your original dataset}

\item{rezero}{Should the beginning of the window be considered the zero point of the timestamp?
Default TRUE}

\item{remove}{Should everything before the beginning and after the end of the window be removed? 
Default TRUE. If set to FALSE and \code{rezero} is set to FALSE, an error is thrown (since in this case,
the function would not do anything).}

\item{window_start_msg}{For method (1). A message that is present only in the row whose time corresponds 
to the trial start time. Common for eyetrackers that send a message at trial/stimuli start.}

\item{window_end_msg}{For method (1). A message that is present only in the row whose time corresponds 
to the trial end time. Common for eyetrackers that send a message at trial-end/keypress/lookaway/etc.}

\item{msg_col}{For method (1). If you are indicating the trial start/end with a message column,
this is the name of that column.}

\item{window_start_col}{For method (2). A column that gives the start time for each trial.}

\item{window_end_col}{For method (2). A column that gives the end time for each trial.}

\item{window_start_time}{For method (3). Number indicating a start time that applies to all trials.}

\item{window_end_time}{For method (3). Number indicating an end time that applies to all trials.}

\item{quiet}{Suppress messages? Default FALSE}
}
\value{
Subsetted data
}
\description{
One of the more annoying aspects of preparing raw eyetracking data is filtering data down into the relevant
window within the trial, since for many experiments the precise start and end time of this window can vary 
from trial to trial. This function allows for several approaches to subsetting data into the relevant time-
window-- see 'Details' below.
}
\details{
\enumerate{
  \item The trial start/end times can be indicated by a message that is sent (e.g., TRIAL_START) in a 
particular row for each trial. In this case, the timestamp of that row is used.
  \item The trial start/end times can be indicated in by a column that specifies trial start/end times for each
trial.
  \item The trial start/end times can be indicated by the actual start and stop time, the same across all
trials (the simplest case).
}

If you only have a start time but the end time doesn't need adjusting, then leave the end time argument blank;
and vice versa.

This function can either rezero your data (the trial start time you select is the new zero-time-point), or 
not. The former is useful when performing initial data-cleaning (e.g., different trial-starts on each 
trial, as indicated by a message), and the latter is useful if you want to "zoom in" on a particular 
portion of your data while keeping obvious the fact that there were other parts of the trial (e.g., an 
image always appears 5000ms-7000ms in the trial, so for one analysis you are only interested in this 
portion).
}
\examples{
data("word_recognition")
data <- make_eyetrackingr_data(word_recognition, 
                               participant_column = "ParticipantName",
                               trial_column = "Trial",
                               time_column = "TimeFromTrialOnset",
                               trackloss_column = "TrackLoss",
                               aoi_columns = c('Animate','Inanimate'),
                               treat_non_aoi_looks_as_missing = TRUE
)

# zoom in to 15500-21000ms
response_window <- subset_by_window(data,
                                    window_start_time = 15500,
                                    window_end_time = 21000, rezero = FALSE, remove = TRUE)

# zoom in to 15500-21000ms and re-zero so timestamps start at 0
response_window <- subset_by_window(data,
                                    window_start_time = 15500, 
                                    window_end_time = 21000, 
                                    rezero = TRUE, 
                                    remove = TRUE)

# keep all data, but re-zero it
response_window <- subset_by_window(data,
                                    window_start_time = 0, 
                                    rezero = TRUE, 
                                    remove = FALSE)

}

