% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/compareFit.R
\name{compareFit}
\alias{compareFit}
\title{Compare two Fit Measure Distributions Using the Wilcoxon-test}
\usage{
compareFit(x, y, ...)
}
\arguments{
\item{x}{An object of the class \code{ezCutoffs} to use in comparison.}

\item{y}{A second \code{ezCutoffs} object to compare \code{x} to.}

\item{...}{Additional arguments to pass to \link[stats]{wilcox.test}.}
}
\value{
An object of the class \code{wilc_result}, inspectable via \code{summary}.
}
\description{
Significane test of the difference between two randomly generated fit index distributions using the Wilcoxon rank sum test.
}
\details{
Non-overlapping fit measures will be disregarded by the funciton.
}
\examples{
## model specification examples

# simple uni-factorial model
model <- "F1 =~ a1 + a2 + a3 + a4 + a5"

## two function calls
a <- ezCutoffs(model = model, n_obs = 1000, n_rep = 10, n_cores = 1, normality = "assumed")
b <- ezCutoffs(model = model, n_obs = 1000, n_rep = 10, n_cores = 1, normality = "empirical")

## comparison of the fit measure distributions yielded by the simulations
w <- compareFit(a, b)
summary(w)
}
\seealso{
\code{\link{ezCutoffs}}
}
