% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/measure-distribution.R
\name{measure_distribution}
\alias{measure_distribution}
\title{Plot the distribution of a numeric (measure) column}
\usage{
measure_distribution(data, measure, type = "hist", bwidth = NULL)
}
\arguments{
\item{data}{A data frame or tibble}

\item{measure}{Unquoted column name of containing numbers (measure)}

\item{type}{Histogram ("hist") or Boxplot ("box")}

\item{bwidth}{width of bin for histogram (by default uses binwidth for 30 bins)}
}
\value{
A ggplot plot object
}
\description{
Plot the distribution of a numeric (measure) column
}
\examples{
measure_distribution(ggplot2::diamonds, price)
measure_distribution(ggplot2::mpg, hwy)
measure_distribution(ggplot2::mpg, hwy, bwidth = 2)
measure_distribution(ggplot2::mpg, hwy, "hist")
measure_distribution(ggplot2::mpg, hwy, "box")
}
