% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fcwtr_scalogram.R
\name{plot.fcwtr_scalogram}
\alias{plot.fcwtr_scalogram}
\title{Scalogram plotting}
\usage{
\method{plot}{fcwtr_scalogram}(x, n = 1000, ...)
}
\arguments{
\item{x}{An object resulting from \code{\link[=fcwt]{fcwt()}}.}

\item{n}{The plotting function reduces the time resolution by averaging
to generate a reasonable graphics format. \code{n} is the number of time
steps that are plotted. Defaults to \code{n = 1000}.}

\item{...}{other arguments passed to specific methods}
}
\value{
No return value, called for side effects.
}
\description{
Plots the scalogram resulting from \code{\link[=fcwt]{fcwt()}}.
Requires \href{https://ggplot2.tidyverse.org/}{ggplot2}.
}
\examples{
\dontshow{if (requireNamespace("ggplot2", quietly = TRUE)) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
ts_sin_440 <- sin((1:4410) * 2 * pi * 440 / 44100)

res <-
  fcwt(
    ts_sin_440,
    sample_freq = 44100,
    freq_begin = 50,
    freq_end = 1000,
    n_freqs = 10,
    sigma = 5
  )

plot(res)
\dontshow{\}) # examplesIf}
}
