% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/reveal_outcomes.R
\name{reveal_outcomes}
\alias{reveal_outcomes}
\title{Reveal outcomes}
\usage{
reveal_outcomes(x)
}
\arguments{
\item{x}{A formula with the outcome name on the left hand side and assignment variables on the right hand side (e.g., \code{Y ~ Z}).}
}
\description{
Implements a generalized switching equation. Reveals observed outcomes from multiple potential outcomes variables and an assignment variable.
}
\examples{

dat <- fabricate(
  N = 10,
  U = rnorm(N),
  potential_outcomes(Y ~ 0.1 * Z + U)
)

fabricate(
  data = dat,
  Z = rbinom(N, 1, prob = 0.5),
  Y = reveal_outcomes(Y ~ Z)
)

fabricate(
  N = 10,
  U = rnorm(N),
  potential_outcomes(Y ~ 0.1 * Z1 + 0.3 * Z2 + 0.5 * Z1 * Z2 + U,
                     conditions = list(Z1 = c(0, 1),
                                       Z2 = c(0, 1))),
  Z1 = rbinom(N, 1, prob = 0.5),
  Z2 = rbinom(N, 1, prob = 0.5),
  Y = reveal_outcomes(Y ~ Z1 + Z2)
)


}
