% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/srh.simple.posthoc.R
\name{srh.simple.posthoc}
\alias{srh.simple.posthoc}
\title{Simple-effects post hoc (Dunn) with Bonferroni adjustment}
\usage{
srh.simple.posthoc(
  formula,
  data,
  compare = NULL,
  scope = c("within", "global"),
  digits = 3
)
}
\arguments{
\item{formula}{A formula of the form \code{y ~ A + B (+ C ...)}; requires
at least two RHS factors to define a simple effect.}

\item{data}{A \code{data.frame} containing variables in \code{formula}.}

\item{compare}{Character; the factor to compare pairwise. By default, the
first factor on the RHS of \code{formula}.}

\item{scope}{\code{"within"} (default) applies Bonferroni adjustment \strong{within
each by-table}; \code{"global"} applies one Bonferroni across \strong{all}
pairwise tests produced for all by-tables combined.}

\item{digits}{Number of digits for rounding numeric columns (\code{Z},
\code{P.unadj}, \code{P.adj}). Default \code{3}.}
}
\value{
A \code{data.frame} with columns:
\itemize{
\item conditioning factor columns (one value repeated per split),
\item \code{Comparison}, \code{Z}, \code{P.unadj}, \code{P.adj},
\item \code{m.tests} (number of tests used for Bonferroni),
\item \code{adj.note} (human-readable note).
}
Attributes: \code{"adjustment"} (one-line description) and \code{"call"}.
}
\description{
Computes Dunn's pairwise comparisons for \strong{simple effects} of one target
factor (\code{compare}) within levels of the remaining conditioning factors
(\code{by}). Adjustment can be done \strong{within} each conditioning table
(SPSS-like) or \strong{globally} across all tests.
}
\details{
The data are subset to complete cases on \code{y} and all RHS factors.
All RHS variables are coerced to \code{factor}. The table is split by all
factors except \code{compare} and Dunn's test (\code{FSA::dunnTest}) is run
per split. With \code{scope = "within"}, the Bonferroni correction is applied
separately in each split (with \code{m.tests = choose(k,2)} for that split).
With \code{scope = "global"}, \code{P.adj} is re-computed once with
\code{stats::p.adjust(..., method = "bonferroni")} across \strong{all} pairwise
tests from all splits (and \code{m.tests} is set to the total number of
tests).
}
\examples{
data(mimicry, package = "factorH")

# Two factors: pairwise comparisons for 'gender' within levels of 'condition'.
# By default, compare = first RHS factor ('gender' here).
# p.adj uses Bonferroni within each by-table (scope = "within").
tab1 <- srh.simple.posthoc(liking ~ gender + condition, data = mimicry)
head(tab1); attr(tab1, "adjustment")

# One global family of tests (global Bonferroni across all subgroup tests):
tab2 <- srh.simple.posthoc(liking ~ gender + condition, data = mimicry,
                           scope = "global")
head(tab2); attr(tab2, "adjustment")

# Three factors: compare 'gender' within each condition × age_cat cell.
tab3 <- srh.simple.posthoc(liking ~ gender + condition + age_cat, data = mimicry)
head(tab3)

# Choose a different target factor to compare: here 'condition'
# (within each gender × age_cat cell).
tabA <- srh.simple.posthoc(liking ~ gender + condition + age_cat, data = mimicry,
                           compare = "condition")
head(tabA)

# Global Bonferroni variants (less common, but sometimes requested):
tabG  <- srh.simple.posthoc(liking ~ gender + condition + age_cat, data = mimicry,
                            scope = "global")
tabG2 <- srh.simple.posthoc(liking ~ condition + gender, data = mimicry)
tabG3 <- srh.simple.posthoc(liking ~ condition + gender, data = mimicry,
                            scope = "global")
head(tabG); head(tabG2); head(tabG3)
}
