% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/visualizations.R
\name{plot.factorMerger}
\alias{plot.factorMerger}
\title{Plot Factor Merger}
\usage{
\method{plot}{factorMerger}(x, panel = "all", statistic = "loglikelihood",
  nodesSpacing = "equidistant", colorClusters = TRUE,
  splitStatistic = "GIC", splitThreshold = NULL, penalty = 2,
  showSplit = FALSE, showSignificance = TRUE,
  title = "Factor Merger Tree", subtitle = " ", palette = NULL,
  responsePanel = NULL, responsePanelPalette = NULL, gicPanelColor = NULL,
  panelGrid = TRUE, chisqQuantile = 0.05, ...)
}
\arguments{
\item{x}{object of a class \code{factorMerger}.}

\item{panel}{Type of panels to be plot. Possible values are \code{c("all", "response", "GIC", "tree")}.
All types of plots include the Factor Merger Tree. Apart from the Factor Merger Tree there are
also two possible panels: the Response Plot (response summary, specific to the model family),
the GIC Plot (GIC vs. loglikelihood/p-value).
\itemize{
\item \code{"all"} plots all panels and a short summary of the full model,
\item \code{"response"} plots the Factor Merger Tree and the Response Plot,
\item \code{"GIC"} plots the Factor Merger Tree and the GIC Plot,
\item \code{"tree"} plots the Factor Merger Tree only.
}}

\item{statistic}{Statistic to be displayed on the OX axis of the Factor Merger Tree.
Possible values are \code{c("loglikelihood", "p-value")}.
If \code{"p-value"} is chosen p-value for the Likelihood Ratio Test against the full model is plot on the OX axis.}

\item{nodesSpacing}{Type of vertical nodes spacing in the Factor Merger Tree). May be chosen from
 \code{c("equidistant", "effects", "modelSpecific")}. \code{"effects"} arranges nodes according to
 the model coefficients estimatiors (e.g. in Gaussian case on the OY axis group means are plotted).

# TODO: Implement "modelSpecific".}

\item{colorClusters}{Boolean. If \code{TRUE}, the default, the Factor Merger Tree is colored according
to the optimal factor split (defined by \code{splitStatistic} and \code{splitThreshold} or
\code{splitStatistic} and \code{penalty}).}

\item{splitStatistic}{Statistic used in the optimal split definition. Possible values are:
\code{c("GIC", "loglikelihood", "p-value")}. If \code{"GIC"} is chosen, factor is split to minimize GIC
with the penalty \code{penalty}. Otherwise, chooses the very last partition whose corresponding statistic
(model loglikelihood or p-value for the LRT test) is not lower than \code{splitThreshold}.}

\item{splitThreshold}{Threshold used in the optimal split definition. Used only with
\code{splitStatistic = c("loglikelihood", "p-value")}.}

\item{penalty}{GIC penalty used for defining the optimal partition with \code{splitStatistic = "GIC"}.
The same penalty is used in the GIC plot.}

\item{showSplit}{Boolean. If \code{TRUE} plots vertical line crossing the optimal split.}

\item{showSignificance}{Boolean. If \code{TRUE}, the default, marks partitions
that are significantly worse than their predecessors on the Factor Merger Tree (uses the Likelihood Ratio Test).

Significance codes are:  0 ‘***’ 0.001 ‘**’ 0.01 ‘*’ 0.05 ‘.’ 0.1 ‘ ’ 1.}

\item{title}{Factor Merger Tree plot's title.}

\item{subtitle}{Factor Merger Tree plot's subtitle.}

\item{palette}{Color palette used in the Factor Merger Tree and the Response Plot.}

\item{responsePanel}{Response panel type -- accepts the following values dependent on the model family:
\itemize{
\item multi dimensional Gaussian: \code{c("heatmap", "profile")},
\item single dimensional Gaussian: \code{c("means", "boxplot")},
\item binomial: \code{c("proportion")},
\item survival: \code{c("survival")}
}}

\item{responsePanelPalette}{Additional color palette used in the Response Plot if
palettes for the Factor Merger Tree and the Response Plot are to be different.}

\item{gicPanelColor}{Color used in the GIC plot.}

\item{panelGrid}{Boolean. If \code{TRUE}, each interval on
the OX axis of the Factor Merger Tree corresponds to the 1 - \code{chisqQuantile}
quantile of chi-square distribution. Otherwise, panel is blank.}

\item{chisqQuantile}{Significance level used if \code{panelGrid = TRUE}.}

\item{...}{Other arguments}
}
\description{
Plot Factor Merger
}
