% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/factorplot.R
\name{summary.factorplot}
\alias{summary.factorplot}
\title{Summary method for objects of class factorplot}
\usage{
\method{summary}{factorplot}(object, ...)
}
\arguments{
\item{object}{An object of class \code{\link[factorplot]{factorplot}}}

\item{\dots}{Other arguments passed to summary, currently not implemented}
}
\value{
\item{Printed Output}{The printed output summarises the number of 
stimuli that are significantly higher or lower and not significantly different
from each other.}
}
\description{
Summarizes the number of significant positive and negative differences for
objects of class \code{\link[factorplot]{factorplot}}
}
\examples{

x <- as.factor(round(runif(1000, .5,5.5)))
levels(x) <- paste("lab", 1:20, sep="")
X <- model.matrix(~x)
b <- rnorm(ncol(X),0,4)
Y.hat <- X \%*\% b 
Y <- Y.hat  + rnorm(1000)
mod <- lm(Y ~ x)
fp <- factorplot(mod, factor.variable="x", pval=0.05, order="alph")
summary(fp)

}
\seealso{
\code{\link[factorplot]{factorplot}}
}
\author{
Dave Armstrong
}
