% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_ceteris_paribus_cutoff.R
\name{plot.ceteris_paribus_cutoff}
\alias{plot.ceteris_paribus_cutoff}
\title{Ceteris paribus cutoff plot}
\usage{
\method{plot}{ceteris_paribus_cutoff}(x, ...)
}
\arguments{
\item{x}{ceteris_paribus_cutoff object}

\item{...}{other plot parameters}
}
\value{
\code{ggplot2} object
}
\description{
Ceteris paribus cutoff is way to check how will parity loss behave if we changed only cutoff in one subgroup.
It plots object of class ceteris_paribus_cutoff. It might have two types - default and cumulated. Cumulated sums metrics and plots
it all in one plot. When default one is used all chosen metrics will be plotted for each model.
}
\examples{

data("compas")

# positive outcome - not being recidivist
two_yr_recidivism <- factor(compas$Two_yr_Recidivism, levels = c(1,0))
y_numeric <- as.numeric(two_yr_recidivism) -1
compas$Two_yr_Recidivism <- two_yr_recidivism


lm_model <- glm(Two_yr_Recidivism~.,
                data=compas,
                family=binomial(link="logit"))

explainer_lm <- DALEX::explain(lm_model, data = compas[,-1], y = y_numeric)

fobject <- fairness_check(explainer_lm,
                          protected = compas$Ethnicity,
                          privileged = "Caucasian")

cpc <- ceteris_paribus_cutoff(fobject, "African_American")
plot(cpc)

\donttest{
rf_model <- ranger::ranger(Two_yr_Recidivism ~.,
                           data = compas,
                           probability = TRUE,
                           num.trees = 200)

explainer_rf <- DALEX::explain(rf_model, data = compas[,-1], y = y_numeric)

fobject <- fairness_check(explainer_lm, explainer_rf,
                          protected = compas$Ethnicity,
                          privileged = "Caucasian")

cpc <- ceteris_paribus_cutoff(fobject, "African_American")
plot(cpc)
}

}
