% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bayes-boot.R
\name{bayes.boot}
\alias{bayes.boot}
\title{Bayesian bootstrap}
\usage{
bayes.boot(x, fun, nboot = 1000, cluster = NULL, ...)
}
\arguments{
\item{x}{a numeric vector to be passed as the first argument to \code{fun}}

\item{fun}{the function to bootstrap; must accept data \code{x} and weights \code{w} (in that
order), and return a data frame}

\item{nboot}{the number of bootstraps to perform}

\item{cluster}{an optional cluster for running bootstraps in parallel; must be set up using
\code{parallel::makeCluster}}

\item{...}{any other arguments for \code{fun}}
}
\value{
An object of class \code{bayes.boot}; a data frame with the following columns:
\item{boot.id}{the bootstrap iteration index}
\item{...}{any columns returned by \code{fun}}
}
\description{
Performs a Bayesian bootstrap for a statistic defined via a suitable function.
}
\examples{
set.seed(123)

boot <- bayes.boot(MASS::galaxies, fun = fit.family, nboot = 100)
head(boot)
}
\author{
Ryan Thompson <ryan.thompson@monash.edu>
}
