% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/VimpTable.R
\name{get_vimp_table}
\alias{get_vimp_table}
\alias{get_vimp_table,list-method}
\alias{get_vimp_table,character-method}
\alias{get_vimp_table,vimpTable-method}
\alias{get_vimp_table,NULL-method}
\alias{get_vimp_table,experimentData-method}
\alias{get_vimp_table,familiarModel-method}
\title{Extract variable importance table.}
\usage{
get_vimp_table(x, state = "ranked", ...)

\S4method{get_vimp_table}{list}(x, state = "ranked", ...)

\S4method{get_vimp_table}{character}(x, state = "ranked", ...)

\S4method{get_vimp_table}{vimpTable}(x, state = "ranked", ...)

\S4method{get_vimp_table}{`NULL`}(x, state = "ranked", ...)

\S4method{get_vimp_table}{experimentData}(x, state = "ranked", ...)

\S4method{get_vimp_table}{familiarModel}(x, state = "ranked", data = NULL, as_object = FALSE, ...)
}
\arguments{
\item{x}{Variable importance (\code{vimpTable}) object, a list thereof, or one or
more paths to these objects. This method extracts the variable importance
table from such objects.}

\item{state}{State of the returned variable importance table. This affects
what contents are shown, and in which format. The variable importance table
can be returned with the following states:
\itemize{
\item \code{initial}: initial state, directly after the variable importance table is
filled. The returned variable importance table shows the raw, un-processed
data.
\item \code{decoded}: depending on the variable importance method, the initial
variable importance table may contain the scores of individual contrasts for
categorical variables. When decoded, scores from all contrasts are
aggregated to a single score for each feature.
\item \code{declustered}: variable importance is determined from fully processed
features, which includes clustering. This means that a single feature in the
variable importance table may represent multiple original features. When a
variable importance table has been declustered, all clusters have been
turned into their constituent features.
\item \code{ranked} (default): The scores have been used to create ranks, with lower
ranks indicating better features.
}

Internally, the variable importance table will go through each state, i.e.
an variable importance table in the initial state will be decoded,
declustered and then ranked prior to returning the variable importance
table.}

\item{...}{Unused arguments.}

\item{data}{Internally used argument for use with \code{familiarModel} objects.}

\item{as_object}{Internally used argument for use with \code{familiarModel}
objects.}
}
\value{
A \code{data.table} with variable importance scores and, with
\code{state="ranked"}, the respective ranks.
}
\description{
This method retrieves and parses variable importance tables from
their respective \code{vimpTable} objects.
}
