% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calc_annual_lowflows.R
\name{calc_annual_lowflows}
\alias{calc_annual_lowflows}
\title{Calculate annual low flows and dates}
\usage{
calc_annual_lowflows(
  data,
  dates = Date,
  values = Value,
  groups = STATION_NUMBER,
  station_number,
  roll_days = c(1, 3, 7, 30),
  roll_align = "right",
  water_year_start = 1,
  start_year,
  end_year,
  exclude_years,
  months = 1:12,
  transpose = FALSE,
  ignore_missing = FALSE
)
}
\arguments{
\item{data}{Data frame of daily data that contains columns of dates, flow values, and (optional) groups (e.g. station numbers).
Leave blank if using \code{station_number} argument.}

\item{dates}{Name of column in \code{data} that contains dates formatted YYYY-MM-DD. Only required if dates column name is not 
'Date' (default). Leave blank if using \code{station_number} argument.}

\item{values}{Name of column in \code{data} that contains numeric flow values, in units of cubic metres per second.
Only required if values column name is not 'Value' (default). Leave blank if using \code{station_number} argument.}

\item{groups}{Name of column in \code{data} that contains unique identifiers for different data sets, if applicable. Only required 
if groups column name is not 'STATION_NUMBER'. Function will automatically group by a column named 'STATION_NUMBER' if 
present. Remove the 'STATION_NUMBER' column beforehand to remove this grouping. Leave blank if using \code{station_number} 
argument.}

\item{station_number}{Character string vector of seven digit Water Survey of Canada station numbers (e.g. \code{"08NM116"}) of
which to extract daily streamflow data from a HYDAT database. Requires \code{tidyhydat} package and a HYDAT database.
Leave blank if using \code{data} argument.}

\item{roll_days}{Numeric value of the number of days to apply a rolling mean. Default \code{1}.}

\item{roll_align}{Character string identifying the direction of the rolling mean from the specified date, either by the first 
(\code{'left'}), last (\code{'right'}), or middle (\code{'center'}) day of the rolling n-day group of observations. 
Default \code{'right'}.}

\item{water_year_start}{Numeric value indicating the month (\code{1} through \code{12}) of the start of water year for
analysis. Default \code{1}.}

\item{start_year}{Numeric value of the first year to consider for analysis. Leave blank to use the first year of the source data.}

\item{end_year}{Numeric value of the last year to consider for analysis. Leave blank to use the last year of the source data.}

\item{exclude_years}{Numeric vector of years to exclude from analysis. Leave blank to include all years.}

\item{months}{Numeric vector of months to include in analysis (e.g. \code{6:8} for Jun-Aug). Leave blank to summarize 
all months (default \code{1:12}).}

\item{transpose}{Logical value indicating whether to transpose rows and columns of results. Default \code{FALSE}.}

\item{ignore_missing}{Logical value indicating whether dates with missing values should be included in the calculation. If
\code{TRUE} then a statistic will be calculated regardless of missing dates. If \code{FALSE} then only those statistics from
time periods with no missing dates will be returned. Default \code{FALSE}.}
}
\value{
A tibble data frame with the following columns:
  \item{Year}{calendar or water year selected}
  \item{Min_'n'_Day}{annual minimum for each n-day rolling mean, direction of mean specified by roll_align}
  \item{Min_'n'_Day_DoY}{day of year for each annual minimum of n-day rolling mean}
  \item{Min_'n'_Day_Date}{date (YYYY-MM-DD) for each annual minimum of n-day rolling mean}
  Default columns:
  \item{Min_1_Day}{annual 1-day mean minimum (roll_align = right)}
  \item{Min_1_Day_DoY}{day of year of annual 1-day mean minimum}
  \item{Min_1_Day_Date}{date (YYYY-MM-DD) of annual 1-day mean minimum}
  \item{Min_3_Day}{annual 3-day mean minimum (roll_align = right)}
  \item{Min_3_Day_DoY}{day of year of annual 3-day mean minimum}
  \item{Min_3_Day_Date}{date (YYYY-MM-DD) of annual 3-day mean minimum}   
  \item{Min_7_Day}{annual 7-day mean minimum (roll_align = right)}
  \item{Min_7_Day_DoY}{day of year of annual 7-day mean minimum}
  \item{Min_7_Day_Date}{date (YYYY-MM-DD) of annual 7-day mean minimum}
  \item{Min_30_Day}{annual 30-day mean minimum (roll_align = right)}
  \item{Min_30_Day_DoY}{day of year of annual 30-day mean minimum}
  \item{Min_30_Day_Date}{date (YYYY-MM-DD) of annual 30-day mean minimum}
  Transposing data creates a column of 'Statistics' and subsequent columns for each year selected. 'Date' statistics
  not transposed.
}
\description{
Calculates annual n-day minimum values, and the day of year and date of occurrence of daily flow values from a daily 
   streamflow data set. Calculates statistics from all values, unless specified. Returns a tibble with statistics.
}
\examples{
# Run if HYDAT database has been downloaded (using tidyhydat::download_hydat())
if (file.exists(tidyhydat::hy_downloaded_db())) {

# Calculate annual 1, 3, 7, and 30-day (default) low flows with 
# default alignment ('right')
calc_annual_lowflows(station_number = "08NM116") 

# Calculate custom 3 and 7-day annual low flows with 'center' alignment
calc_annual_lowflows(station_number = "08NM116",
                     roll_days = c(3,7),
                     roll_align = "center")
                     
}
}
