% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/adaboost_m1.R
\name{adaboost}
\alias{adaboost}
\title{Adaboost.M1 algorithm}
\usage{
adaboost(formula, data, nIter, ...)
}
\arguments{
\item{formula}{Formula for models}

\item{data}{Input dataframe}

\item{nIter}{no. of classifiers}

\item{...}{other optional arguments, not implemented now}
}
\value{
object of class adaboost
}
\description{
Implements Freund and Schapire's Adaboost.M1 algorithm
}
\details{
This implements the Adaboost.M1 algorithm for a binary classification task.
The target variable must be a factor with exactly two levels.
The final classifier is a linear combination of weak decision tree classifiers.
}
\examples{
fakedata <- data.frame( X=c(rnorm(100,0,1),rnorm(100,1,1)), Y=c(rep(0,100),rep(1,100) ) )
fakedata$Y <- factor(fakedata$Y)
test_adaboost <- adaboost(Y~X, data=fakedata,10)
}
\references{
Freund, Y. and Schapire, R.E. (1996):\dQuote{Experiments with a new boosting algorithm}
. \emph{In Proceedings of the Thirteenth International Conference on Machine Learning}, 
pp. 148--156, Morgan Kaufmann.
}
\seealso{
\code{\link{real_adaboost}}, \code{\link{predict.adaboost}}
}

