% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/undirected_erdos_renyi.R
\name{erdos_renyi}
\alias{erdos_renyi}
\title{Create an undirected erdos renyi object}
\usage{
erdos_renyi(n, ..., p = NULL)
}
\arguments{
\item{n}{Number of nodes in graph.}

\item{...}{
  Arguments passed on to \code{\link[=undirected_factor_model]{undirected_factor_model}}
  \describe{
    \item{\code{expected_degree}}{If specified, the desired expected degree
of the graph. Specifying \code{expected_degree} simply rescales \code{S}
to achieve this. Defaults to \code{NULL}. Do not specify both
\code{expected_degree} and \code{expected_density} at the same time.}
  }}

\item{p}{Probability of an edge between any two nodes. You must specify
either \code{p} or \code{expected_degree}.}
}
\value{
Never returns Poisson edges.
}
\description{
Create an undirected erdos renyi object
}
\examples{

set.seed(87)

er <- erdos_renyi(n = 10, p = 0.1)
er


er <- erdos_renyi(n = 10, expected_density = 0.1)
er

big_er <- erdos_renyi(n = 10^6, expected_degree = 5)
big_er

A <- sample_sparse(er)
A

}
\seealso{
Other bernoulli graphs: 
\code{\link{directed_erdos_renyi}()}

Other erdos renyi: 
\code{\link{directed_erdos_renyi}()}

Other undirected graphs: 
\code{\link{dcsbm}()},
\code{\link{planted_partition}()},
\code{\link{sbm}()}
}
\concept{bernoulli graphs}
\concept{erdos renyi}
\concept{undirected graphs}
