% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/phf_pbp.R
\name{load_phf_pbp}
\alias{load_phf_pbp}
\title{\strong{Load fastRhockey PHF play-by-play}}
\usage{
load_phf_pbp(
  seasons = most_recent_phf_season(),
  ...,
  dbConnection = NULL,
  tablename = NULL
)
}
\arguments{
\item{seasons}{A vector of 4-digit years associated with given PHF seasons. (Min: 2011)}

\item{...}{Additional arguments passed to an underlying function that writes
the season data into a database (used by \code{update_phf_db()}).}

\item{dbConnection}{A \code{DBIConnection} object, as returned by \code{\link[DBI:dbConnect]{DBI::dbConnect()}}}

\item{tablename}{The name of the play by play data table within the database}
}
\value{
A dataframe
}
\description{
helper that loads multiple seasons from the data repo either into memory
or writes it into a db using some forwarded arguments in the dots
}
\examples{
\donttest{
load_phf_pbp(2021)
}
}
