% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/collab.R
\name{collab_learner}
\alias{collab_learner}
\title{Collab_learner}
\usage{
collab_learner(
  dls,
  n_factors = 50,
  use_nn = FALSE,
  emb_szs = NULL,
  layers = NULL,
  config = NULL,
  y_range = NULL,
  loss_func = NULL,
  opt_func = Adam(),
  lr = 0.001,
  splitter = trainable_params(),
  cbs = NULL,
  metrics = NULL,
  path = NULL,
  model_dir = "models",
  wd = NULL,
  wd_bn_bias = FALSE,
  train_bn = TRUE,
  moms = list(0.95, 0.85, 0.95)
)
}
\arguments{
\item{dls}{a data loader object}

\item{n_factors}{The number of factors}

\item{use_nn}{use_nn}

\item{emb_szs}{embedding size}

\item{layers}{list of layers}

\item{config}{configuration}

\item{y_range}{y_range}

\item{loss_func}{It can be any loss function you like. It needs to be one of fastai's if you want to use Learn.predict or Learn.get_preds, or you will have to implement special methods (see more details after the BaseLoss documentation).}

\item{opt_func}{The function used to create the optimizer}

\item{lr}{learning rate}

\item{splitter}{It is a function that takes self.model and returns a list of parameter groups (or just one parameter group if there are no different parameter groups).}

\item{cbs}{Cbs is one or a list of Callbacks to pass to the Learner.}

\item{metrics}{It is an optional list of metrics, that can be either functions or Metrics.}

\item{path}{The folder where to work}

\item{model_dir}{Path and model_dir are used to save and/or load models.}

\item{wd}{It is the default weight decay used when training the model.}

\item{wd_bn_bias}{It controls if weight decay is applied to BatchNorm layers and bias.}

\item{train_bn}{It controls if BatchNorm layers are trained even when they are supposed to be frozen according to the splitter.}

\item{moms}{The default momentums used in Learner.fit_one_cycle.}
}
\value{
learner object
}
\description{
Create a Learner for collaborative filtering on `dls`.
}
\examples{

\dontrun{

URLs_MOVIE_LENS_ML_100k()
c(user,item,title)  \%<-\% list('userId','movieId','title')
ratings = fread('ml-100k/u.data', col.names = c(user,item,'rating','timestamp'))
movies = fread('ml-100k/u.item', col.names = c(item, 'title', 'date', 'N', 'url',
                                               paste('g',1:19,sep = '')))
rating_movie = ratings[movies[, .SD, .SDcols=c(item,title)], on = item]
dls = CollabDataLoaders_from_df(rating_movie, seed = 42, valid_pct = 0.1, bs = 64,
item_name=title, path='ml-100k')

learn = collab_learner(dls, n_factors = 40, y_range=c(0, 5.5))

learn \%>\% fit_one_cycle(1, 5e-3,  wd = 1e-1)

}

}
