% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/regress.r
\name{regress,GRaster,missing-method}
\alias{regress,GRaster,missing-method}
\alias{regress}
\title{Regression intercept, slope, r2, and t-value across each set of cells}
\usage{
\S4method{regress}{GRaster,missing}(y, x, na.rm = FALSE)
}
\arguments{
\item{y}{A multi-layer \code{GRaster}.}

\item{x}{Ignored.}

\item{na.rm}{Logical: If \code{FALSE}, any series of cells with \code{NA} in at least one cell results in an \code{NA} in the output.}
}
\value{
A multi-layer \code{GRaster}.
}
\description{
This function performs a regression on each set of cells in a multi-layered \code{GRaster}. The output is a \code{GRaster} with the intercept, slope, r^2 value, and Student's t value. The regression formula is as \code{y ~ 1 + x}, where \code{x} is the layer number of each layer (e.g., 1 for the first or top layer in the input \code{GRaster}, 2 for the second or second-to-top layer, etc.). Note that this is restricted version of the functionality in \code{\link[terra:regress]{terra::regress()}}.
}
\examples{
if (grassStarted()) {

# Setup
library(sf)
library(terra)

# Example data
madChelsa <- fastData("madChelsa")

# Convert a SpatRaster to a GRaster
chelsa <- fast(madChelsa)
chelsa # 4 layers

# Central tendency
mean(chelsa)
mmode(chelsa)
median(chelsa)

# Statistics
nunique(chelsa)
sum(chelsa)
count(chelsa)
min(chelsa)
max(chelsa)
range(chelsa)
skewness(chelsa)
kurtosis(chelsa)

stdev(chelsa)
stdev(chelsa, pop = FALSE)
var(chelsa)
varpop(chelsa)

# Which layers have maximum/minimum?
which.min(chelsa)
which.max(chelsa)

# Regression

# Note the intercept is different for fasterRaster::regress().
regress(chelsa)
regress(madChelsa, 1:nlyr(madChelsa))

# Note: To get quantiles for each layer, use global().
quantile(chelsa, 0.1)

# NAs
madForest2000 <- fastData("madForest2000")
forest2000 <- fast(madForest2000)
forest2000 <- project(forest2000, chelsa, method = "near")

chelsaForest <- c(chelsa, forest2000)

nas <- anyNA(chelsaForest)
plot(nas)

allNas <- allNA(chelsaForest)
plot(allNas)

}
}
\seealso{
\code{\link[terra:regress]{terra::regress()}}
}
