% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get-stock-data.R
\name{get_stock_data}
\alias{get_stock_data}
\title{Returns pricing data for a specified stock}
\usage{
get_stock_data(symbol, start_date, end_date)
}
\arguments{
\item{symbol}{A string indicating the symbol of the stock in the PSE and Yahoo
Finance. For more details, you can refer to this
\href{https://www.pesobility.com/stock}{link}.}

\item{start_date}{A string indicating a date in the YYYY-mm-dd format, serves
as the start date of the period to get stock data}

\item{end_date}{A string indicating a date in the YYYY-mm-dd format, serves
as the end date of the period to get stock data}
}
\value{
A tibble, with the following columns:
\itemize{
\item symbol: The ticker symbol of the stock
\item dt: The date for the closing price of the stock
\item name: The name of the company represented by the stock ticker
\item currency: The currency of the closing price of the stock
\item close: The closing price of the stock at the given date, dt
\item percent_change: The percentage day change of the stock
\item volume: The total value of shares traded of the stock at dt
}
}
\description{
Returns pricing data for a specified stock
}
\examples{
\donttest{
  get_stock_data("JFC", "2019-01-03", "2019-02-01") # PSE data
  get_stock_data("MSFT", "2019-01-03", "2019-02-01") # US data
}

}
