% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/API.R
\name{build_supervised}
\alias{build_supervised}
\title{Build a supervised fasttext model}
\usage{
build_supervised(documents, targets, model_path, lr = 0.05, dim = 100,
  ws = 5, epoch = 5, minCount = 5, minCountLabel = 0, neg = 5,
  wordNgrams = 1, loss = c("ns", "hs", "softmax"), bucket = 2e+06,
  minn = 3, maxn = 6, thread = 12, lrUpdateRate = 100, t = 1e-04,
  label = "__label__", verbose = 2, pretrainedVectors = NULL)
}
\arguments{
\item{documents}{character vector of documents used for training}

\item{targets}{vector of targets/catagory of each document. Must have same length as \code{documents} and be coercable to character}

\item{model_path}{Name of output file \emph{without} file extension.}

\item{lr}{learning rate}

\item{dim}{size of word vectors}

\item{ws}{size of the context window}

\item{epoch}{number of epochs}

\item{minCount}{minimal number of word occurences}

\item{minCountLabel}{minimal number of label occurences}

\item{neg}{number of negatives sampled}

\item{wordNgrams}{max length of word ngram}

\item{loss}{= c('softmax', 'ns', 'hs'), loss function {ns, hs, softmax}}

\item{bucket}{number of buckets}

\item{minn}{min length of char ngram}

\item{maxn}{max length of char ngram}

\item{thread}{number of threads}

\item{lrUpdateRate}{change the rate of updates for the learning rate}

\item{t}{sampling threshold}

\item{label}{text string, labels prefix. Default is "\strong{label}"}

\item{verbose}{verbosity level}

\item{pretrainedVectors}{path to pretrained word vectors for supervised learning. Leave empty for no pretrained vectors.}
}
\value{
path to new model file as a \code{character}
}
\description{
Trains a supervised model, following the method layed out in
\href{https://arxiv.org/abs/1607.01759}{Bag of Tricks for Efficient Text Classification}
using the \href{https://fasttext.cc/}{fasttext} implementation.

See \href{https://fasttext.cc/docs/en/supervised-tutorial.html}{FastText text classification tutorial} for more information on
training supervised models using fasttext.
}
\examples{
\dontrun{
library(fastrtext)
model_file <- build_supervised(documents = train_sentences[["text"]],
                               targets =train_sentences[["class.text"]],
                               model_path = 'my_model',
                               dim = 20, lr = 1, epoch = 20, wordNgrams = 2)

model <- load_model(model_file)

predictions <- predict(model, test_sentences[["text"]])
mean(sapply(predictions, names) == test_sentences[["class.text"]])
# ~0.8
}
}
