% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/distribution_convertors.R
\name{norm2unif}
\alias{norm2unif}
\title{Convert normal to uniform}
\usage{
norm2unif(x, min = 0, max = 1, mu = mean(x), sd = stats::sd(x))
}
\arguments{
\item{x}{the normally distributed vector}

\item{min}{the minimum of the uniform distribution to return}

\item{max}{the maximum of the uniform distribution to return}

\item{mu}{the mean of x (calculated from x if not given)}

\item{sd}{the SD of x (calculated from x if not given)}
}
\value{
a vector with a uniform distribution
}
\description{
Convert a normal (gaussian) distribution to a uniform distribution with specified minimum and maximum
}
\examples{

x <- rnorm(10000)
y <- norm2unif(x)
g <- ggplot2::ggplot() + ggplot2::geom_point(ggplot2::aes(x, y))
ggExtra::ggMarginal(g, type = "histogram")

}
