% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/directional_outlyingness.R
\name{dir_out}
\alias{dir_out}
\title{Dai & Genton (2019) Directional outlyingness for univariate or multivariate functional data.}
\usage{
dir_out(
  dts,
  data_depth = "random_projections",
  n_projections = 200L,
  seed = NULL,
  return_distance = TRUE,
  return_dir_matrix = FALSE
)
}
\arguments{
\item{dts}{A matrix (or data frame) for univariate functional data (of size \code{n} observations by \code{p} domain
points) or a 3-dimensional array for multivariate functional data (of size \code{n}
observations by \code{p} domain points by \code{d} dimension).}

\item{data_depth}{The method for computing the depth. The random projection depth is
always used as suggested in Dai and Genton (2018) \doi{10.1080/10618600.2018.1473781}.
Support for more depth methods will be added.}

\item{n_projections}{The number of directions for computing random projection depth. By default,
200 random directions are generated from a scaled uniform distribution between -1 and 1.}

\item{seed}{An integer indicating the seed to set when generating the random directions. Defaults to NULL
in which case a seed is not set.}

\item{return_distance}{A logical value. If TRUE, returns: a matrix whose columns are
the mean and variation of directional outlyingness, the mahalanobis distance of the
observations of this matrix, and the robust estimate of the mean and covariance of
this matrix (computed using the minimum covariance determinant method).}

\item{return_dir_matrix}{A logical value. If TRUE, returns the directional outlyingness
matrix (or array for multivariate functional data). Computed from the chosen \code{depth_depth}.}
}
\value{
Returns a list containing:
\item{mean_outlyingness}{an \code{n x d} matrix of the mean
 of directional outlyingness.} \item{var_outlyingness}{ a vector of length n containing
 the variation of directional outlyingness.}
 \item{ms_matrix}{ if\code{return_distance} = T, an \code{n x (d+1)} matrix whose columns are the mean and
 variation of directional outlyingness.}
 \item{distance}{ if \code{return_distance} = T, a vector of distance computed from the
 \code{ms_matrix} using a robust estimate of the mean and covariance matrix.}
 \item{mcd_obj}{ if \code{return_distance} = T, a list containing the robust
 (minimum covariance determinant) estimate of the mean and covariance of the \code{ms_matrix}.}
 \item{dirout_matrix}{ if \code{return_dir_matrix} = T, an n x p (or n x p x d) matrix (or array)
  containing the directional outlyingness values for the univariate (or multivariate) functional \code{dts}.}
}
\description{
Compute the directional outlyingness of a univariate or multivariate functional data
based on Dai and Genton (2019) \doi{10.1016/j.csda.2018.03.017}
and Dai and Genton (2018) \doi{10.1080/10618600.2018.1473781}.
}
\details{
The directional outlyingness, as defined in Dai and Genton (2019)
\doi{10.1016/j.csda.2018.03.017} is
\deqn{O(Y, F_Y) = (1/d(Y, F_Y) - 1).v} where \eqn{d} is a depth notion, and \eqn{v} is
the unit vector pointing from the median of \eqn{F_Y} to \eqn{Y}. For univariate and
multivariate functional data, the projection depth is always used as suggested by
Dai and Genton (2019) \doi{10.1016/j.csda.2018.03.017}.
}
\examples{
# univariate magnitude model in Dai and Genton (2018).
dt4 <- simulation_model4()
dirout_object <- dir_out(dts = dt4$data, return_distance = TRUE)
}
\references{
Dai, W., and Genton, M. G. (2018). Multivariate functional data
visualization and outlier detection. \emph{Journal of Computational and Graphical
Statistics}, 27(4), 923-934.

Dai, W., and Genton, M. G. (2019). Directional outlyingness for multivariate functional
data. \emph{Computational Statistics & Data Analysis}, 131, 50-65.

Zuo, Y. (2003). Projection-based depth functions and associated medians. \emph{The
Annals of Statistics}, 31(5), 1460-1490.
}
\seealso{
\code{\link{msplot}} for outlier detection using msplot and \code{\link{projection_depth}}
 for multivariate projection depth.
}
\author{
Oluwasegun Taiwo Ojo.
}
