% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/FOptDes.R
\name{FOptDes}
\alias{FOptDes}
\title{Optimal Designs for Functional and Longitudinal Data
for Trajectory Recovery or Scalar Response Prediction}
\usage{
FOptDes(Ly, Lt, Resp, p = 3, optns = list(),
  isRegression = !missing(Resp), isSequential = FALSE, RidgeCand = NULL)
}
\arguments{
\item{Ly}{A list of \emph{n} vectors containing the observed values for each individual. Missing values specified by \code{NA}s are supported for dense case (\code{dataType='dense'}).}

\item{Lt}{A list of \emph{n} vectors containing the observation time points for each individual corresponding to y. Each vector should be sorted in ascending order.}

\item{Resp}{A vector of response values, keep void for trajectory recovery, only necessary for scalar response prediction task.}

\item{p}{A fixed positive integer indicating the number of optimal design points requested, with default: 3.}

\item{optns}{A list of options control parameters specified by \code{list(name=value)} for FPCA, with default: list().}

\item{isRegression}{A logical argument, indicating the purpose of the optimal designs: TRUE for scalar response prediction, FALSE for trajectory recovery, with default value !missing(Resp).}

\item{isSequential}{A logical argument, indicating whether to use the sequential optimization procedure for faster computation, recommended for relatively large p (default: FALSE).}

\item{RidgeCand}{A vector of positive numbers as ridge penalty candidates for regularization. The final value is selected via cross validation. If only 1 ridge parameter is specified, CV procedure is skipped.}
}
\value{
A list containing the following fields:
\item{OptDes}{The vector of optimal design points of the regular time grid of the observed data.}
\item{R2}{Coefficient of determination. (Check the paper for details.)}
\item{R2adj}{Adjusted coefficient of determination.}
\item{OptRidge}{The selected ridge parameter.}
}
\description{
Optimal Designs for Functional and Longitudinal Data
for Trajectory Recovery or Scalar Response Prediction
}
\details{
To select a proper RidgeCand, check with the returned optimal ridge parameter. If the selected parameter is the maximum/minimum values in the candidates, it is possible that the selected one is too small/big.
}
\examples{
set.seed(1)
n <- 50
pts <- seq(0, 1, by=0.05)
sampWiener <- Wiener(n, pts)
sampWiener <- MakeFPCAInputs(IDs = rep(1:n, each=length(pts)), 
                             tVec = rep(pts, times = n), 
                             yVec = t(sampWiener))
res <- FOptDes(Ly=sampWiener$Ly, Lt=sampWiener$Lt, p=2,
               isSequential=FALSE, RidgeCand = seq(0.02,0.2,0.02))
}
\references{
\cite{Ji, H., Mueller, H.G. (2016) "Optimal Designs for Longitudinal and Functional Data" Journal of the Royal Statistical Society: Series B (Statistical Methodology)}
}

