% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/jointfPCA.R
\name{jointFPCA}
\alias{jointFPCA}
\title{Joint Vertical and Horizontal Functional Principal Component Analysis}
\usage{
jointFPCA(
  warp_data,
  no,
  id = round(length(warp_data$time)/2),
  C = NULL,
  showplot = T
)
}
\arguments{
\item{warp_data}{fdawarp objecet from \link{time_warping} of aligned data}

\item{no}{number of prinicpal components to extract}

\item{id}{integration point for f0 (default = midpoint)}

\item{C}{balance value (default = NULL)}

\item{showplot}{show plots of prinipal directions (default = T)}
}
\value{
Returns a list containing \item{q_pca}{srvf principal directions}
\item{f_pca}{f principal directions}
\item{latent}{latent values}
\item{coef}{coefficients}
\item{U}{eigenvectors}
\item{mu_psi}{mean psi function}
\item{mu_g}{mean g function}
\item{id}{point use for f(0)}
\item{C}{optimized phase amplitude ratio}
}
\description{
This function calculates amplitude and phase joint  functional principal component
analysis on aligned data
}
\examples{
data("simu_warp")
data("simu_data")
jfpca = jointFPCA(simu_warp, no = 3)
}
\references{
Srivastava, A., Wu, W., Kurtek, S., Klassen, E., Marron, J. S.,
 May 2011. Registration of functional data using fisher-rao metric,
 arXiv:1103.3817v2 [math.ST].

Jung, S. L. a. S. (2016). "Combined Analysis of Amplitude and Phase Variations in Functional Data."
       	arXiv:1603.01775 [stat.ME].

Tucker, J. D., Wu, W., Srivastava, A.,
 Generative Models for Function Data using Phase and Amplitude Separation,
 Computational Statistics and Data Analysis (2012), 10.1016/j.csda.2012.12.001.
}
\keyword{alignment}
\keyword{srvf}
