% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/joint_gauss_model.R
\name{joint_gauss_model}
\alias{joint_gauss_model}
\title{Gaussian model of functional data using joint Model}
\usage{
joint_gauss_model(warp_data, n = 1, no = 5)
}
\arguments{
\item{warp_data}{fdawarp object from \link{time_warping} of aligned data}

\item{n}{number of random samples (n = 1)}

\item{no}{number of principal components (n=4)}
}
\value{
Returns a fdawarp object containing \item{fs}{random aligned samples}
\item{gams}{random warping function samples}
\item{ft}{random function samples}
\item{qs}{random srvf samples}
}
\description{
This function models the functional data using a Gaussian model extracted from
the principal components of the srvfs using the joint model
}
\examples{
data("simu_warp")
out1 = joint_gauss_model(simu_warp,n = 10)
}
\references{
Tucker, J. D., Wu, W., Srivastava, A.,
 Generative Models for Function Data using Phase and Amplitude Separation,
 Computational Statistics and Data Analysis (2012), 10.1016/j.csda.2012.12.001.

Jung, S. L. a. S. (2016). "Combined Analysis of Amplitude and Phase Variations in Functional Data."
       	arXiv:1603.01775 [stat.ME].
}
\keyword{pca}
