% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/1_outcomes.R
\name{ffs_adp_outcomes}
\alias{ffs_adp_outcomes}
\title{Connects ff_scoringhistory to past ADP rankings}
\usage{
ffs_adp_outcomes(
  scoring_history,
  gp_model = "simple",
  pos_filter = c("QB", "RB", "WR", "TE")
)
}
\arguments{
\item{scoring_history}{a scoring history table as created by \code{ffscrapr::ff_scoringhistory()}}

\item{gp_model}{either "simple" or "none" - simple uses the average games played per season for each position/adp combination, none assumes every game is played.}

\item{pos_filter}{a character vector: filter the positions returned to these specific positions, default: c("QB","RB","WR","TE)}
}
\value{
a dataframe with position, rank, probability of games played, and a corresponding nested list per row of all week score outcomes.
}
\description{
The backbone of the ffsimulator resampling process is coming up with a population of weekly outcomes for every preseason positional rank. This function creates that dataframe by connecting historical FantasyPros.com rankings to nflfastR-based scoring data, as created by \code{ffscrapr::ff_scoringhistory()}.
}
\examples{
\donttest{
# cached data
scoring_history <- .ffs_cache("mfl_scoring_history.rds")

ffs_adp_outcomes(scoring_history, gp_model = "simple")
ffs_adp_outcomes(scoring_history, gp_model = "none")
}

}
\seealso{
\code{fp_rankings_history} for the included historical rankings

\code{fp_injury_table} for the historical injury table

\code{vignette("custom")} for usage details.
}
