% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/miscellaneous.R
\name{pastep}
\alias{pastep}
\title{Concatenate paths}
\usage{
pastep(..., list_of_paths = NULL, ext = NULL)
}
\arguments{
\item{...}{A Set of Path Strings. Only works if list_of_paths is NULL}

\item{list_of_paths}{Either a vector or a list of paths strings}

\item{ext}{An Extension to add at the end of the path}
}
\value{
A Character of length one, the combined path.
}
\description{
Concatenates two or more strings to a path string correctly.
}
\examples{
pastep('a', 'b', 'c', 'd')
pastep(list_of_paths = list(paste0('/', letters, '/'), as.character(1:13)))
pastep(list_of_paths = c(letters, as.character(1:13)))
pastep(list_of_paths = c(letters, as.character(1:13)), ext = '.txt')
pastep(list_of_paths = c(letters, as.character(1:13)), ext = '_dat.txt')
}
