% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sample_resources.R
\name{fhir_get_resources_by_ids}
\alias{fhir_get_resources_by_ids}
\title{Get Resources by their IDs}
\usage{
fhir_get_resources_by_ids(
  base_url,
  resource,
  ids,
  id_param = "_id",
  parameters = NULL,
  username = NULL,
  password = NULL,
  token = NULL,
  add_headers = NULL,
  verbose = 0
)
}
\arguments{
\item{base_url}{A character vector of length one specifying the base URL of the FHIR server, e.g. \code{"http://hapi.fhir.org/baseR4"}.}

\item{resource}{A character vector of length one or \linkS4class{fhir_resource_type} object with the resource type to be searched, e.g. \code{"Patient"}.}

\item{ids}{A character vector containing the IDs of the resources that should be downloaded. In the default setting these should be resource (aka logical) IDs.}

\item{id_param}{A character vector of length one containing the FHIR Search parameter belonging to the ids in \code{ids}. Defaults to \code{"_id"} meaning \code{ids} is interpreted as
containing resource (aka logical) ids. Could be changed to \code{"identifier"} if \code{ids} contains a vector of identifier values instead.}

\item{parameters}{FHIR Search parameters to further restrict the set of resources that is returned, e.g. \code{gender=male} to only download the resources from
the \code{ids} list that correspond to males. Can be either a length 1 character containing properly formatted FHIR search parameters, e.g.
\code{"gender=male"} or a named list or named character vector e.g. \code{list(gender="male")}or \code{c(gender="male")}. Defaults to \code{NULL} meaning no restriction on
the IDs provided in \code{ids}.}

\item{username}{A character vector of length one containing the username for basic authentication.}

\item{password}{A character vector of length one containing the password for basic authentication.}

\item{token}{A character vector of length one or object of class \link[httr:Token-class]{httr::Token}, for bearer token authentication (e.g. OAuth2). See \code{\link[=fhir_authenticate]{fhir_authenticate()}}
for how to create this.}

\item{add_headers}{A named character vector of custom headers to add to the HTTP request, e.g. \code{c(myHeader = "somevalue")} or
\code{c(firstHeader = "value1", secondHeader = "value2")}.}

\item{verbose}{An integer vector of length 1 containing the level of verbosity. Defaults to 0.}
}
\value{
A \linkS4class{fhir_bundle_list} containing the downloaded resources.
}
\description{
Downloads FHIR resources represented by a vector of resource IDs.
}
\details{
This function takes a character vector \code{ids} containing logical Ids of resources of a given type (specified in \code{resource}) on a
FHIR server (specified in \code{base_url}) and downloads the corresponding resources from the server. The function will attempt to download the resources using a
FHIR search request via POST where the IDs are part of the body. See \code{\link[=fhir_search]{fhir_search()}} for details. If this fails
(e.g. because the server doesn't allow POST operations), the function falls back on a GET request. If the set of ids is too long to fit
into one GET request (i.e. if the request gets longer than 2083 characters), it will be spread across several requests.

For more information on authentication options, please see the help page of \code{\link[=fhir_search]{fhir_search()}}
}
\examples{
\donttest{

#the try({}, silent = TRUE) statement is only there to catch errors when the server is down
#you can skip it when the server is reachable

try({

#find IDs of Patient resources representing Homer Simpson
ids <- fhir_get_resource_ids(
  base_url   = 'https://hapi.fhir.org/baseR4',
  resource   = "Patient",
  parameters = "name=Homer&name=Simpson")

#Download all corresponding resources
bundles <- fhir_get_resources_by_ids(
  base_url = 'https://hapi.fhir.org/baseR4',
  resource = "Patient",
  ids      = ids)

#have a look at the resources
fhir_crack(
  bundles,
  fhir_table_description(
    resource = "Patient",
    cols     = list(
      ID      = "id",
      given   = "name/given",
      family  = "name/family")))

}, silent = TRUE)
}
}
\seealso{
\code{\link[=fhir_search]{fhir_search()}}, \code{\link[=fhir_get_resource_ids]{fhir_get_resource_ids()}}
}
