% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mape.R
\name{mape}
\alias{mape}
\title{mape}
\usage{
mape(x, na.rm = TRUE)
}
\arguments{
\item{x}{A vector of class \emph{numeric}.}

\item{na.rm}{Logical. Should the NA values be excluded. Default is TRUE.}
}
\value{
A \emph{numeric} element.
}
\description{
Mean Absolute Percent Error (MAPE).
}
\details{
{Estimates the Mean Absolute Percent Error (MAPE) for a given vector. The MAPE compares the individual values against their mean and
translates the mean of the differences into a percent deviation from the mean of the vector. The MAPE is estimated as:
\deqn{100 / length(x) * sum(abs((x-mean(x))/x))}}
}
\examples{
{

x <- c(0.1, 0.3, 0.4, 0.1, 0.2, 0.6)
m <- mape(x)

}
}
\seealso{
\code{\link{relative.freq}} \code{\link{ccLabel}}
}
