% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/files.R
\name{unitize_dirs}
\alias{unitize_dirs}
\title{Put files with the same unit measurements into directories}
\usage{
unitize_dirs(unit, pattern = NULL, dir = ".")
}
\arguments{
\item{unit}{The unit upon which to base the categorizing.}

\item{pattern}{If set, only files with names matching this pattern will be
treated.}

\item{dir}{In which directory do you want to perform this action (defaults
to current)?}
}
\value{
Invisibly \code{TRUE} if the operation is successful, if not there will be an
error.
}
\description{
Say you have a number of files with "5min" in their names, number with
"10min" in the names, a number with "15min" in their names and so on, and
you'd like to put them into directories named "5min", "10min", "15min" and so
on. This function does this, but not just for the unit "min", for any unit.
}
\details{
This function takes the number to be the last number (as defined in
\code{\link[=nth_number]{nth_number()}}) before the first occurrence of the unit name. There
is the option to only treat files matching a certain pattern.
}
\examples{
setwd(tempdir())
dir.create("UnitDirs_test")
setwd("UnitDirs_test")
files <- c("1litres_1.txt", "1litres_3.txt", "3litres.txt", "5litres_1.txt")
file.create(files)
unitize_dirs("litres", "\\\\.txt")
setwd("..")
dir.remove("UnitDirs_test")
}
