% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/all-equal.R
\name{all_equal}
\alias{all_equal}
\title{An alternative version of \code{\link[base:all.equal]{base::all.equal()}}.}
\usage{
all_equal(a, b = NULL)
}
\arguments{
\item{a}{A vector, array or list.}

\item{b}{Either \code{NULL} or a vector, array or list of length either 1 or
\code{length(a)}.}
}
\value{
\code{TRUE} if "equality of all" is satisfied (as detailed in
'Description' above) and \code{FALSE} otherwise.
}
\description{
This function will return \code{TRUE} whenever \code{\link[base:all.equal]{base::all.equal()}}
would return \code{TRUE}, however it will also return \code{TRUE} in some other cases:
\itemize{
\item If \code{a} is given and \code{b} is not, \code{TRUE} will be returned if all of the
elements of \code{a} are the same.
\item If \code{a} is a scalar and \code{b} is a vector or array, \code{TRUE} will be returned
if every element in \code{b} is equal to \code{a}.
\item If \code{a} is a vector or array and \code{b} is a scalar, \code{TRUE} will be returned
if every element in \code{a} is equal to \code{b}.
}

This function ignores names and attributes (except for \code{dim}).

When this function does not return \code{TRUE}, it returns \code{FALSE} (unless it
errors). This is unlike \code{\link[base:all.equal]{base::all.equal()}}.
}
\note{
\itemize{\item This behaviour is totally different from
\code{\link[base:all.equal]{base::all.equal()}}. \item There's also \code{\link[dplyr:all_equal]{dplyr::all_equal()}}, which is
different again. To avoid confusion, always use the full
\code{filesstrings::all_equal()} and never \code{library(filesstrings)} followed by
just \code{all_equal()}.}
}
\examples{
all_equal(1, rep(1, 3))
all_equal(2, 1:3)
all_equal(1:4, 1:4)
all_equal(1:4, c(1, 2, 3, 3))
all_equal(rep(1, 10))
all_equal(c(1, 88))
all_equal(1:2)
all_equal(list(1:2))
all_equal(1:4, matrix(1:4, nrow = 2)) # note that this gives TRUE
}
